/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.util.math.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Quad
implements Shape {
    private Point2D[] points;
    private Path2D path;

    public static Quad get(Rectangle2D rectangle) {
        return new Quad(Quad.getPoints(rectangle));
    }

    public static Point2D[] getPoints(Rectangle2D rectangle) {
        Point2D[] points = new Point2D[]{new Point2D.Double(rectangle.getMinX(), rectangle.getMinY()), new Point2D.Double(rectangle.getMaxX(), rectangle.getMinY()), new Point2D.Double(rectangle.getMaxX(), rectangle.getMaxY()), new Point2D.Double(rectangle.getMinX(), rectangle.getMaxY())};
        return points;
    }

    public Quad(Point2D ... points) {
        this.setPoints(points);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.getPath().contains(p);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.getPath().contains(r);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.getPath().contains(x, y);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.getPath().contains(x, y, w, h);
    }

    @Override
    public Rectangle getBounds() {
        return this.getPath().getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getPath().getBounds2D();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.getPath().getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPath().getPathIterator(at, flatness);
    }

    public Point2D[] getPoints() {
        return this.points;
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.getPath().intersects(r);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.getPath().intersects(x, y, w, h);
    }

    public void setPoints(Point2D[] value) {
        if (value.length != 4) {
            throw new IllegalArgumentException("'points' MUST have a cardinality of 4.");
        }
        this.points = value;
        this.path = null;
    }

    private Path2D getPath() {
        if (this.path == null) {
            Point2D[] point2DArray = this.points;
            int n = this.points.length;
            int n2 = 0;
            while (n2 < n) {
                Point2D point = point2DArray[n2];
                if (this.path == null) {
                    this.path = new Path2D.Double(0);
                    this.path.moveTo(point.getX(), point.getY());
                } else {
                    this.path.lineTo(point.getX(), point.getY());
                }
                ++n2;
            }
            this.path.closePath();
        }
        return this.path;
    }
}

