/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.util.math;

public final class Interval<T extends Comparable<? super T>> {
    private T high = null;
    private boolean highInclusive;
    private T low = null;
    private boolean lowInclusive;

    public Interval(T low, T high) {
        this(low, high, true, true);
    }

    public Interval(T low, T high, boolean lowInclusive, boolean highInclusive) {
        this.low = low;
        this.high = high;
        this.lowInclusive = lowInclusive;
        this.highInclusive = highInclusive;
    }

    public boolean contains(T value) {
        int highCompare;
        int lowCompare = this.low != null ? this.low.compareTo(value) : -1;
        int n = highCompare = this.high != null ? this.high.compareTo(value) : 1;
        return (lowCompare < 0 || lowCompare == 0 && this.lowInclusive) && (highCompare > 0 || highCompare == 0 && this.highInclusive);
    }

    public T getHigh() {
        return this.high;
    }

    public T getLow() {
        return this.low;
    }

    public boolean isHighInclusive() {
        return this.highInclusive;
    }

    public boolean isLowInclusive() {
        return this.lowInclusive;
    }

    public void setHigh(T value) {
        this.high = value;
    }

    public void setHighInclusive(boolean value) {
        this.highInclusive = value;
    }

    public void setLow(T value) {
        this.low = value;
    }

    public void setLowInclusive(boolean value) {
        this.lowInclusive = value;
    }
}

