/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.util;

import java.util.Hashtable;
import java.util.Map;

public class BiMap<K, V>
extends Hashtable<K, V> {
    private static final long serialVersionUID = 1L;
    private final Hashtable<V, K> inverseMap = new Hashtable();

    public BiMap() {
    }

    public BiMap(int initialCapacity) {
        super(initialCapacity);
    }

    public BiMap(Map<? extends K, ? extends V> map) {
        this.putAll(map);
    }

    @Override
    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.inverseMap.containsKey(value);
    }

    public K getKey(V value) {
        return this.inverseMap.get(value);
    }

    @Override
    public V put(K key, V value) {
        V oldValue = super.put(key, value);
        if (oldValue != null) {
            this.inverseMap.remove(oldValue);
        }
        this.inverseMap.put(value, key);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAllInverse(Map<? extends V, ? extends K> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<V, K> entry : map.entrySet()) {
            this.put(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public V remove(Object key) {
        Object value = super.remove(key);
        if (value != null) {
            this.inverseMap.remove(value);
        }
        return value;
    }
}

