/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.tools;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import org.pdfclown.documents.contents.Contents;
import org.pdfclown.documents.contents.IContentContext;

public final class Renderer {
    public boolean print(Pageable document) throws PrinterException {
        return this.print(document, true);
    }

    public boolean print(Pageable document, boolean silent) throws PrinterException {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPageable(document);
        if (!silent && !printJob.printDialog()) {
            return false;
        }
        printJob.print();
        return true;
    }

    public BufferedImage render(Contents contents, Dimension2D size) {
        return this.render(contents, size, null);
    }

    public BufferedImage render(IContentContext contentContext, Dimension2D size) {
        return this.render(contentContext, size, null);
    }

    public BufferedImage render(Contents contents, Dimension2D size, Rectangle2D area) {
        return this.render(contents.getContentContext(), size, area);
    }

    public BufferedImage render(IContentContext contentContext, Dimension2D size, Rectangle2D area) {
        BufferedImage image = new BufferedImage((int)size.getWidth(), (int)size.getHeight(), 4);
        contentContext.render(image.createGraphics(), size);
        return image;
    }
}

