/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.tokens;

import java.io.EOFException;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.pdfclown.bytes.Buffer;
import org.pdfclown.bytes.IBuffer;
import org.pdfclown.bytes.IOutputStream;
import org.pdfclown.files.File;
import org.pdfclown.objects.IVisitor;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.objects.PdfStream;
import org.pdfclown.tokens.XRefEntry;
import org.pdfclown.util.ConvertUtils;
import org.pdfclown.util.parsers.ParseException;

public final class XRefStream
extends PdfStream
implements Map<Integer, XRefEntry> {
    private static final int FreeEntryType = 0;
    private static final int InUseEntryType = 1;
    private static final int InUseCompressedEntryType = 2;
    private static final double ByteBaseLog = Math.log(256.0);
    private static final int EntryField0Size = 1;
    private static final int EntryField2Size = XRefStream.getFieldSize(65535);
    private SortedMap<Integer, XRefEntry> entries;

    private static int getFieldSize(int maxValue) {
        return (int)Math.ceil(Math.log(maxValue) / ByteBaseLog);
    }

    private static byte[] numberToByteArray(int value, int length) {
        return ConvertUtils.numberToByteArray(value, length, ByteOrder.BIG_ENDIAN);
    }

    public XRefStream(File file) {
        this(new PdfDictionary(new PdfName[]{PdfName.Type}, new PdfDirectObject[]{PdfName.XRef}), new Buffer());
        PdfDictionary header = this.getHeader();
        for (Map.Entry<PdfName, PdfDirectObject> entry : file.getTrailer().entrySet()) {
            PdfName key = entry.getKey();
            if (!key.equals(PdfName.Root) && !key.equals(PdfName.Info) && !key.equals(PdfName.ID)) continue;
            header.put(key, entry.getValue());
        }
    }

    public XRefStream(PdfDictionary header, IBuffer body) {
        super(header, body);
    }

    @Override
    public PdfObject accept(IVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public int getLinkedStreamOffset() {
        PdfInteger linkedStreamOffsetObject = (PdfInteger)this.getHeader().get(PdfName.Prev);
        return linkedStreamOffsetObject != null ? linkedStreamOffsetObject.getValue() : -1;
    }

    @Override
    public void writeTo(IOutputStream stream, File context) {
        if (this.entries != null) {
            this.flush(stream);
        }
        super.writeTo(stream, context);
    }

    @Override
    public void clear() {
        if (this.entries == null) {
            this.entries = new TreeMap<Integer, XRefEntry>();
        } else {
            this.entries.clear();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntries().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getEntries().containsValue(value);
    }

    @Override
    public Set<Map.Entry<Integer, XRefEntry>> entrySet() {
        return this.getEntries().entrySet();
    }

    @Override
    public XRefEntry get(Object key) {
        return (XRefEntry)this.getEntries().get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.getEntries().isEmpty();
    }

    @Override
    public Set<Integer> keySet() {
        return this.getEntries().keySet();
    }

    @Override
    public XRefEntry put(Integer key, XRefEntry value) {
        return this.getEntries().put(key, value);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends XRefEntry> entries) {
        this.getEntries().putAll(entries);
    }

    @Override
    public XRefEntry remove(Object key) {
        return (XRefEntry)this.getEntries().remove(key);
    }

    @Override
    public int size() {
        return this.getEntries().size();
    }

    @Override
    public Collection<XRefEntry> values() {
        return this.getEntries().values();
    }

    private void flush(IOutputStream stream) {
        PdfArray indexArray = new PdfArray();
        int[] entryFieldSizes = new int[]{1, XRefStream.getFieldSize((int)stream.getLength()), EntryField2Size};
        IBuffer body = this.getBody();
        body.setLength(0);
        int prevObjectNumber = -2;
        for (XRefEntry entry : this.entries.values()) {
            int entryNumber = entry.getNumber();
            if (entryNumber - prevObjectNumber != 1) {
                if (!indexArray.isEmpty()) {
                    indexArray.add(PdfInteger.get(prevObjectNumber - ((PdfInteger)indexArray.get(indexArray.size() - 1)).getValue() + 1));
                }
                indexArray.add(PdfInteger.get(entryNumber));
            }
            prevObjectNumber = entryNumber;
            switch (entry.getUsage()) {
                case Free: {
                    body.append((byte)0);
                    body.append(XRefStream.numberToByteArray(entry.getOffset(), entryFieldSizes[1]));
                    body.append(XRefStream.numberToByteArray(entry.getGeneration(), entryFieldSizes[2]));
                    break;
                }
                case InUse: {
                    body.append((byte)1);
                    body.append(XRefStream.numberToByteArray(entry.getOffset(), entryFieldSizes[1]));
                    body.append(XRefStream.numberToByteArray(entry.getGeneration(), entryFieldSizes[2]));
                    break;
                }
                case InUseCompressed: {
                    body.append((byte)2);
                    body.append(XRefStream.numberToByteArray(entry.getStreamNumber(), entryFieldSizes[1]));
                    body.append(XRefStream.numberToByteArray(entry.getOffset(), entryFieldSizes[2]));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        indexArray.add(PdfInteger.get(prevObjectNumber - ((PdfInteger)indexArray.get(indexArray.size() - 1)).getValue() + 1));
        PdfDictionary header = this.getHeader();
        header.put(PdfName.Index, indexArray);
        header.put(PdfName.Size, PdfInteger.get(this.getFile().getIndirectObjects().size() + 1));
        header.put(PdfName.W, new PdfArray(PdfInteger.get(entryFieldSizes[0]), PdfInteger.get(entryFieldSizes[1]), PdfInteger.get(entryFieldSizes[2])));
    }

    private SortedMap<Integer, XRefEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new TreeMap<Integer, XRefEntry>();
            IBuffer body = this.getBody();
            if (body.getLength() > 0L) {
                PdfArray subsectionBounds;
                PdfDictionary header = this.getHeader();
                int size = ((PdfInteger)header.get(PdfName.Size)).getValue();
                PdfArray entryFieldSizesObject = (PdfArray)header.get(PdfName.W);
                int[] entryFieldSizes = new int[entryFieldSizesObject.size()];
                int index = 0;
                int length = entryFieldSizes.length;
                while (index < length) {
                    entryFieldSizes[index] = ((PdfInteger)entryFieldSizesObject.get(index)).getValue();
                    ++index;
                }
                if (header.containsKey(PdfName.Index)) {
                    subsectionBounds = (PdfArray)header.get(PdfName.Index);
                } else {
                    subsectionBounds = new PdfArray();
                    subsectionBounds.add(PdfInteger.get(0));
                    subsectionBounds.add(PdfInteger.get(size));
                }
                body.setByteOrder(ByteOrder.BIG_ENDIAN);
                body.seek(0L);
                Iterator<PdfDirectObject> subsectionBoundIterator = subsectionBounds.iterator();
                while (subsectionBoundIterator.hasNext()) {
                    try {
                        int start = ((PdfInteger)subsectionBoundIterator.next()).getValue();
                        int count = ((PdfInteger)subsectionBoundIterator.next()).getValue();
                        int entryIndex = start;
                        int length2 = start + count;
                        while (entryIndex < length2) {
                            int entryFieldType = entryFieldSizes[0] == 0 ? 1 : body.readInt(entryFieldSizes[0]);
                            switch (entryFieldType) {
                                case 0: {
                                    int nextFreeObjectNumber = body.readInt(entryFieldSizes[1]);
                                    int generation = body.readInt(entryFieldSizes[2]);
                                    this.entries.put(entryIndex, new XRefEntry(entryIndex, generation, nextFreeObjectNumber, XRefEntry.UsageEnum.Free));
                                    break;
                                }
                                case 1: {
                                    int offset = body.readInt(entryFieldSizes[1]);
                                    int generation = body.readInt(entryFieldSizes[2]);
                                    this.entries.put(entryIndex, new XRefEntry(entryIndex, generation, offset, XRefEntry.UsageEnum.InUse));
                                    break;
                                }
                                case 2: {
                                    int streamNumber = body.readInt(entryFieldSizes[1]);
                                    int innerNumber = body.readInt(entryFieldSizes[2]);
                                    this.entries.put(entryIndex, new XRefEntry(entryIndex, innerNumber, streamNumber));
                                    break;
                                }
                                default: {
                                    throw new UnsupportedOperationException("Unknown xref entry type '" + entryFieldType + "'.");
                                }
                            }
                            ++entryIndex;
                        }
                    }
                    catch (EOFException e) {
                        throw new ParseException("Unexpected EOF (malformed cross-reference stream object).", e);
                    }
                }
            }
        }
        return this.entries;
    }
}

