/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.tokens;

import java.io.Closeable;
import java.io.IOException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.pdfclown.Version;
import org.pdfclown.bytes.IInputStream;
import org.pdfclown.files.File;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.tokens.FileParser;
import org.pdfclown.tokens.XRefEntry;
import org.pdfclown.tokens.XRefStream;
import org.pdfclown.util.parsers.ParseException;
import org.pdfclown.util.parsers.PostScriptParser;

public final class Reader
implements Closeable {
    private FileParser parser;

    public Reader(IInputStream stream, File file) {
        this.parser = new FileParser(stream, file);
    }

    public int hashCode() {
        return this.parser.hashCode();
    }

    public FileParser getParser() {
        return this.parser;
    }

    public FileInfo readInfo() {
        Version version = Version.get(this.parser.retrieveVersion());
        PdfDictionary trailer = null;
        TreeMap<Integer, XRefEntry> xrefEntries = new TreeMap<Integer, XRefEntry>();
        long sectionOffset = this.parser.retrieveXRefOffset();
        while (sectionOffset > -1L) {
            PdfInteger prevXRefOffset;
            PdfDictionary sectionTrailer;
            this.parser.seek(sectionOffset);
            if (this.parser.getToken(1).equals("xref")) {
                block1: while (true) {
                    this.parser.moveNext();
                    if (this.parser.getTokenType() == PostScriptParser.TokenTypeEnum.Keyword && this.parser.getToken().equals("trailer")) break;
                    if (this.parser.getTokenType() != PostScriptParser.TokenTypeEnum.Integer) {
                        throw new ParseException("Neither object number of the first object in this xref subsection nor end of xref section found.", this.parser.getPosition());
                    }
                    int startObjectNumber = (Integer)this.parser.getToken();
                    this.parser.moveNext();
                    if (this.parser.getTokenType() != PostScriptParser.TokenTypeEnum.Integer) {
                        throw new ParseException("Number of entries in this xref subsection not found.", this.parser.getPosition());
                    }
                    int endObjectNumber = (Integer)this.parser.getToken() + startObjectNumber;
                    int index = startObjectNumber;
                    while (true) {
                        if (index >= endObjectNumber) continue block1;
                        if (xrefEntries.containsKey(index)) {
                            this.parser.moveNext(3);
                        } else {
                            XRefEntry.UsageEnum usage;
                            int offset = (Integer)this.parser.getToken(1);
                            int generation = (Integer)this.parser.getToken(1);
                            String usageToken = (String)this.parser.getToken(1);
                            if (usageToken.equals("n")) {
                                usage = XRefEntry.UsageEnum.InUse;
                            } else if (usageToken.equals("f")) {
                                usage = XRefEntry.UsageEnum.Free;
                            } else {
                                throw new ParseException("Invalid xref entry.", this.parser.getPosition());
                            }
                            xrefEntries.put(index, new XRefEntry(index, generation, offset, usage));
                        }
                        ++index;
                    }
                    break;
                }
                sectionTrailer = (PdfDictionary)this.parser.parsePdfObject(1);
            } else {
                XRefStream stream = (XRefStream)this.parser.parsePdfObject(3);
                for (XRefEntry xrefEntry : stream.values()) {
                    if (xrefEntries.containsKey(xrefEntry.getNumber())) continue;
                    xrefEntries.put(xrefEntry.getNumber(), xrefEntry);
                }
                sectionTrailer = stream.getHeader();
            }
            if (trailer == null) {
                trailer = sectionTrailer;
            }
            sectionOffset = (prevXRefOffset = (PdfInteger)sectionTrailer.get(PdfName.Prev)) != null ? prevXRefOffset.getValue() : -1;
        }
        return new FileInfo(version, trailer, xrefEntries);
    }

    @Override
    public void close() throws IOException {
        if (this.parser != null) {
            this.parser.close();
            this.parser = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public static final class FileInfo {
        private final PdfDictionary trailer;
        private final Version version;
        private final SortedMap<Integer, XRefEntry> xrefEntries;

        FileInfo(Version version, PdfDictionary trailer, SortedMap<Integer, XRefEntry> xrefEntries) {
            this.version = version;
            this.trailer = trailer;
            this.xrefEntries = xrefEntries;
        }

        public PdfDictionary getTrailer() {
            return this.trailer;
        }

        public Version getVersion() {
            return this.version;
        }

        public SortedMap<Integer, XRefEntry> getXrefEntries() {
            return this.xrefEntries;
        }
    }
}

