/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.tokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.pdfclown.bytes.Buffer;
import org.pdfclown.bytes.IBuffer;
import org.pdfclown.bytes.IOutputStream;
import org.pdfclown.files.File;
import org.pdfclown.files.IndirectObjects;
import org.pdfclown.objects.IVisitor;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.objects.PdfStream;
import org.pdfclown.tokens.Chunk;
import org.pdfclown.tokens.FileParser;
import org.pdfclown.tokens.XRefEntry;
import org.pdfclown.util.MapEntry;

public final class ObjectStream
extends PdfStream
implements Map<Integer, PdfDataObject> {
    private Map<Integer, ObjectEntry> entries;
    private FileParser parser;

    public ObjectStream() {
        super(new PdfDictionary(new PdfName[]{PdfName.Type}, new PdfDirectObject[]{PdfName.ObjStm}));
    }

    public ObjectStream(PdfDictionary header, IBuffer body) {
        super(header, body);
    }

    @Override
    public PdfObject accept(IVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public ObjectStream getBaseStream() {
        return (ObjectStream)this.getHeader().resolve(PdfName.Extends);
    }

    public void setBaseStream(ObjectStream value) {
        this.getHeader().put(PdfName.Extends, value.getReference());
    }

    @Override
    public void writeTo(IOutputStream stream, File context) {
        if (this.entries != null) {
            this.flush(stream);
        }
        super.writeTo(stream, context);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntries().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public Set<Map.Entry<Integer, PdfDataObject>> entrySet() {
        HashSet<Map.Entry<Integer, PdfDataObject>> entrySet = new HashSet<Map.Entry<Integer, PdfDataObject>>();
        for (Integer key : this.getEntries().keySet()) {
            entrySet.add(new MapEntry<Integer, PdfDataObject>(key, this.get(key)));
        }
        return entrySet;
    }

    @Override
    public PdfDataObject get(Object key) {
        ObjectEntry entry = this.getEntries().get(key);
        return entry != null ? entry.getDataObject() : null;
    }

    @Override
    public boolean isEmpty() {
        return this.getEntries().isEmpty();
    }

    @Override
    public Set<Integer> keySet() {
        return this.getEntries().keySet();
    }

    @Override
    public PdfDataObject put(Integer key, PdfDataObject value) {
        PdfDataObject removedDataObject = null;
        ObjectEntry removedEntry = this.getEntries().put(key, new ObjectEntry(value));
        if (removedEntry != null) {
            removedDataObject = removedEntry.getDataObject();
        }
        return removedDataObject;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends PdfDataObject> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PdfDataObject remove(Object key) {
        PdfDataObject removedDataObject = null;
        ObjectEntry removedEntry = this.getEntries().remove(key);
        if (removedEntry != null) {
            removedDataObject = removedEntry.getDataObject();
        }
        return removedDataObject;
    }

    @Override
    public int size() {
        return this.getEntries().size();
    }

    @Override
    public Collection<PdfDataObject> values() {
        ArrayList<PdfDataObject> values = new ArrayList<PdfDataObject>();
        for (Integer key : this.getEntries().keySet()) {
            values.add(this.get(key));
        }
        return values;
    }

    private void flush(IOutputStream stream) {
        Buffer indexBuffer = new Buffer();
        Buffer dataBuffer = new Buffer();
        IndirectObjects indirectObjects = this.getFile().getIndirectObjects();
        int objectIndex = -1;
        File context = this.getFile();
        for (Map.Entry<Integer, ObjectEntry> entry : this.getEntries().entrySet()) {
            int objectNumber = entry.getKey();
            XRefEntry xrefEntry = indirectObjects.get(objectNumber).getXrefEntry();
            xrefEntry.setOffset(++objectIndex);
            int entryValueOffset = (int)dataBuffer.getLength();
            indexBuffer.append(Integer.toString(objectNumber)).append(Chunk.Space).append(Integer.toString(entryValueOffset)).append(Chunk.Space);
            entry.getValue().getDataObject().writeTo(dataBuffer, context);
            entry.getValue().offset = entryValueOffset;
        }
        IBuffer body = this.getBody();
        body.setLength(0);
        body.append(indexBuffer);
        int dataByteOffset = (int)body.getLength();
        body.append(dataBuffer);
        PdfDictionary header = this.getHeader();
        header.put(PdfName.N, PdfInteger.get(this.getEntries().size()));
        header.put(PdfName.First, PdfInteger.get(dataByteOffset));
    }

    private Map<Integer, ObjectEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new HashMap<Integer, ObjectEntry>();
            IBuffer body = this.getBody();
            if (body.getLength() > 0L) {
                this.parser = new FileParser(body, this.getFile());
                int baseOffset = ((PdfInteger)this.getHeader().get(PdfName.First)).getValue();
                int index = 0;
                int length = ((PdfInteger)this.getHeader().get(PdfName.N)).getValue();
                while (index < length) {
                    int objectNumber = ((PdfInteger)this.parser.parsePdfObject(1)).getValue();
                    int objectOffset = baseOffset + ((PdfInteger)this.parser.parsePdfObject(1)).getValue();
                    this.entries.put(objectNumber, new ObjectEntry(objectOffset));
                    ++index;
                }
            }
        }
        return this.entries;
    }

    private final class ObjectEntry {
        private PdfDataObject dataObject;
        private int offset;

        public ObjectEntry(int offset) {
            this.dataObject = null;
            this.offset = offset;
        }

        public ObjectEntry(PdfDataObject dataObject) {
            this.dataObject = dataObject;
            this.offset = -1;
        }

        public PdfDataObject getDataObject() {
            if (this.dataObject == null) {
                ObjectStream.this.parser.seek(this.offset);
                ObjectStream.this.parser.moveNext();
                this.dataObject = ObjectStream.this.parser.parsePdfObject();
            }
            return this.dataObject;
        }
    }
}

