/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.tokens;

import java.io.EOFException;
import org.pdfclown.bytes.Buffer;
import org.pdfclown.bytes.IInputStream;
import org.pdfclown.files.File;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfReference;
import org.pdfclown.objects.PdfStream;
import org.pdfclown.tokens.BaseParser;
import org.pdfclown.tokens.ObjectStream;
import org.pdfclown.tokens.XRefStream;
import org.pdfclown.util.parsers.ParseException;
import org.pdfclown.util.parsers.PostScriptParser;

public final class FileParser
extends BaseParser {
    private static final int EOFMarkerChunkSize = 1024;
    private final File file;

    FileParser(IInputStream stream, File file) {
        super(stream);
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public boolean moveNext() {
        boolean moved = super.moveNext();
        if (moved) {
            switch (this.getTokenType()) {
                case Integer: {
                    IInputStream stream = this.getStream();
                    long baseOffset = stream.getPosition();
                    int objectNumber = (Integer)this.getToken();
                    super.moveNext();
                    if (this.getTokenType() == PostScriptParser.TokenTypeEnum.Integer) {
                        int generationNumber = (Integer)this.getToken();
                        super.moveNext();
                        if (this.getTokenType() == PostScriptParser.TokenTypeEnum.Keyword && this.getToken().equals("R")) {
                            this.setToken(new Reference(objectNumber, generationNumber));
                        }
                    }
                    if (this.getToken() instanceof Reference) break;
                    stream.seek(baseOffset);
                    this.setToken(objectNumber);
                    this.setTokenType(PostScriptParser.TokenTypeEnum.Integer);
                }
            }
        }
        return moved;
    }

    @Override
    public PdfDataObject parsePdfObject() {
        switch (this.getTokenType()) {
            case Keyword: {
                if (!(this.getToken() instanceof Reference)) break;
                return new PdfReference((Reference)this.getToken(), this.file);
            }
        }
        PdfDataObject pdfObject = super.parsePdfObject();
        if (pdfObject instanceof PdfDictionary) {
            IInputStream stream = this.getStream();
            int oldOffset = (int)stream.getPosition();
            this.moveNext();
            if (this.getTokenType() == PostScriptParser.TokenTypeEnum.Keyword && this.getToken().equals("stream")) {
                PdfDictionary streamHeader = (PdfDictionary)pdfObject;
                long position = stream.getPosition();
                int length = ((PdfInteger)streamHeader.resolve(PdfName.Length)).getValue();
                stream.seek(position);
                this.skipEOL();
                byte[] data = new byte[length];
                try {
                    stream.read(data);
                }
                catch (EOFException e) {
                    throw new ParseException("Unexpected EOF (malformed stream object).", e, stream.getPosition());
                }
                this.moveNext();
                PdfDirectObject streamType = streamHeader.get(PdfName.Type);
                if (PdfName.ObjStm.equals(streamType)) {
                    return new ObjectStream(streamHeader, new Buffer(data));
                }
                if (PdfName.XRef.equals(streamType)) {
                    return new XRefStream(streamHeader, new Buffer(data));
                }
                return new PdfStream(streamHeader, new Buffer(data));
            }
            stream.seek(oldOffset);
        }
        return pdfObject;
    }

    public String retrieveVersion() {
        String header;
        IInputStream stream = this.getStream();
        stream.seek(0L);
        try {
            header = stream.readString(10);
        }
        catch (EOFException e) {
            throw new ParseException(e);
        }
        if (!header.startsWith("%PDF-")) {
            throw new ParseException("PDF header not found.", stream.getPosition());
        }
        return header.substring("%PDF-".length(), "%PDF-".length() + 3);
    }

    public long retrieveXRefOffset() {
        int index;
        IInputStream stream = this.getStream();
        long streamLength = stream.getLength();
        int chunkSize = (int)Math.min(streamLength, 1024L);
        long position = streamLength - (long)chunkSize;
        stream.seek(position);
        try {
            index = stream.readString(chunkSize).lastIndexOf("startxref");
        }
        catch (EOFException e) {
            throw new ParseException(e);
        }
        if (index < 0) {
            throw new ParseException("'startxref' keyword not found.", stream.getPosition());
        }
        stream.seek(position + (long)index);
        this.moveNext();
        this.moveNext();
        if (this.getTokenType() != PostScriptParser.TokenTypeEnum.Integer) {
            throw new ParseException("'startxref' value invalid.", stream.getPosition());
        }
        return ((Integer)this.getToken()).intValue();
    }

    public class Reference {
        private final int generationNumber;
        private final int objectNumber;

        private Reference(int objectNumber, int generationNumber) {
            this.objectNumber = objectNumber;
            this.generationNumber = generationNumber;
        }

        public int getGenerationNumber() {
            return this.generationNumber;
        }

        public int getObjectNumber() {
            return this.objectNumber;
        }
    }
}

