/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.tokens;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.pdfclown.bytes.IOutputStream;
import org.pdfclown.files.File;
import org.pdfclown.files.IndirectObjects;
import org.pdfclown.objects.PdfIndirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.tokens.FileParser;
import org.pdfclown.tokens.ObjectStream;
import org.pdfclown.tokens.Writer;
import org.pdfclown.tokens.XRefEntry;
import org.pdfclown.tokens.XRefStream;
import org.pdfclown.util.NotImplementedException;

final class CompressedWriter
extends Writer {
    CompressedWriter(File file, IOutputStream stream) {
        super(file, stream);
    }

    @Override
    protected void writeIncremental() {
        FileParser parser = this.file.getReader().getParser();
        this.stream.write(parser.getStream());
        IndirectObjects indirectObjects = this.file.getIndirectObjects();
        XRefStream xrefStream = new XRefStream(this.file);
        XRefEntry prevFreeEntry = null;
        HashMap<Integer, ObjectStream> extensionObjectStreams = new HashMap<Integer, ObjectStream>();
        for (PdfIndirectObject indirectObject : new ArrayList<PdfIndirectObject>(indirectObjects.getModifiedObjects().values())) {
            prevFreeEntry = this.addXRefEntry(indirectObject.getXrefEntry(), indirectObject, xrefStream, prevFreeEntry, extensionObjectStreams);
        }
        for (ObjectStream extensionObjectStream : extensionObjectStreams.values()) {
            prevFreeEntry = this.addXRefEntry(extensionObjectStream.getContainer().getXrefEntry(), extensionObjectStream.getContainer(), xrefStream, prevFreeEntry, null);
        }
        if (prevFreeEntry != null) {
            prevFreeEntry.setOffset(0);
        }
        XRefEntry xrefStreamEntry = new XRefEntry(indirectObjects.size(), 0);
        new PdfIndirectObject(this.file, xrefStream, xrefStreamEntry);
        this.updateTrailer(xrefStream.getHeader(), this.stream);
        xrefStream.getHeader().put(PdfName.Prev, PdfInteger.get((int)parser.retrieveXRefOffset()));
        this.addXRefEntry(xrefStreamEntry, xrefStream.getContainer(), xrefStream, null, null);
        this.writeTail(xrefStreamEntry.getOffset());
    }

    @Override
    protected void writeLinearized() {
        throw new NotImplementedException();
    }

    @Override
    protected void writeStandard() {
        this.writeHeader();
        IndirectObjects indirectObjects = this.file.getIndirectObjects();
        XRefStream xrefStream = new XRefStream(this.file);
        XRefEntry xrefStreamEntry = new XRefEntry(indirectObjects.size(), 0);
        new PdfIndirectObject(this.file, xrefStream, xrefStreamEntry);
        XRefEntry prevFreeEntry = null;
        for (PdfIndirectObject indirectObject : indirectObjects) {
            prevFreeEntry = this.addXRefEntry(indirectObject.getXrefEntry(), indirectObject, xrefStream, prevFreeEntry, null);
        }
        prevFreeEntry.setOffset(0);
        this.updateTrailer(xrefStream.getHeader(), this.stream);
        this.addXRefEntry(xrefStreamEntry, xrefStream.getContainer(), xrefStream, null, null);
        this.writeTail(xrefStreamEntry.getOffset());
    }

    private XRefEntry addXRefEntry(XRefEntry xrefEntry, PdfIndirectObject indirectObject, XRefStream xrefStream, XRefEntry prevFreeEntry, Map<Integer, ObjectStream> extensionObjectStreams) {
        xrefStream.put(xrefEntry.getNumber(), xrefEntry);
        switch (xrefEntry.getUsage()) {
            case InUse: {
                int offset = (int)this.stream.getLength();
                indirectObject.writeTo(this.stream, this.file);
                xrefEntry.setOffset(offset);
                break;
            }
            case InUseCompressed: {
                if (extensionObjectStreams == null) break;
                int baseStreamNumber = xrefEntry.getStreamNumber();
                PdfIndirectObject baseStreamIndirectObject = this.file.getIndirectObjects().get(baseStreamNumber);
                if (!baseStreamIndirectObject.isOriginal()) break;
                ObjectStream extensionObjectStream = extensionObjectStreams.get(baseStreamNumber);
                if (extensionObjectStream == null) {
                    extensionObjectStream = new ObjectStream();
                    this.file.register(extensionObjectStream);
                    extensionObjectStream.setBaseStream((ObjectStream)baseStreamIndirectObject.getDataObject());
                    extensionObjectStreams.put(baseStreamNumber, extensionObjectStream);
                }
                extensionObjectStream.put(xrefEntry.getNumber(), indirectObject.getDataObject());
                xrefEntry.setStreamNumber(extensionObjectStream.getReference().getObjectNumber());
                xrefEntry.setOffset(-1);
                break;
            }
            case Free: {
                if (prevFreeEntry != null) {
                    prevFreeEntry.setOffset(xrefEntry.getNumber());
                }
                prevFreeEntry = xrefEntry;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return prevFreeEntry;
    }
}

