/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.objects;

import org.pdfclown.objects.IVisitor;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfBoolean;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDate;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfIndirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.objects.PdfReal;
import org.pdfclown.objects.PdfReference;
import org.pdfclown.objects.PdfStream;
import org.pdfclown.objects.PdfString;
import org.pdfclown.objects.PdfTextString;
import org.pdfclown.tokens.ObjectStream;
import org.pdfclown.tokens.XRefStream;

public class Visitor
implements IVisitor {
    @Override
    public PdfObject visit(ObjectStream object, Object data) {
        for (PdfDataObject value : object.values()) {
            value.accept(this, data);
        }
        return object;
    }

    @Override
    public PdfObject visit(PdfArray object, Object data) {
        for (PdfDirectObject item : object) {
            if (item == null) continue;
            item.accept(this, data);
        }
        return object;
    }

    @Override
    public PdfObject visit(PdfBoolean object, Object data) {
        return object;
    }

    @Override
    public PdfObject visit(PdfDataObject object, Object data) {
        return object.accept(this, data);
    }

    @Override
    public PdfObject visit(PdfDate object, Object data) {
        return object;
    }

    @Override
    public PdfObject visit(PdfDictionary object, Object data) {
        for (PdfDirectObject value : object.values()) {
            if (value == null) continue;
            value.accept(this, data);
        }
        return object;
    }

    @Override
    public PdfObject visit(PdfIndirectObject object, Object data) {
        PdfDataObject dataObject = object.getDataObject();
        if (dataObject != null) {
            dataObject.accept(this, data);
        }
        return object;
    }

    @Override
    public PdfObject visit(PdfInteger object, Object data) {
        return object;
    }

    @Override
    public PdfObject visit(PdfName object, Object data) {
        return object;
    }

    @Override
    public PdfObject visit(PdfReal object, Object data) {
        return object;
    }

    @Override
    public PdfObject visit(PdfReference object, Object data) {
        object.getIndirectObject().accept(this, data);
        return object;
    }

    @Override
    public PdfObject visit(PdfStream object, Object data) {
        return object;
    }

    @Override
    public PdfObject visit(PdfString object, Object data) {
        return object;
    }

    @Override
    public PdfObject visit(PdfTextString object, Object data) {
        return object;
    }

    @Override
    public PdfObject visit(XRefStream object, Object data) {
        return object;
    }
}

