/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.objects;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.pdfclown.documents.Document;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfReal;

public final class Rectangle
extends PdfObjectWrapper<PdfArray> {
    public static Rectangle wrap(PdfDirectObject baseObject) {
        return baseObject != null ? new Rectangle(baseObject) : null;
    }

    private static PdfArray normalize(PdfArray rectangle) {
        if (rectangle.get(0).compareTo(rectangle.get(2)) > 0) {
            PdfDirectObject leftCoordinate = rectangle.get(2);
            rectangle.set(2, rectangle.get(0));
            rectangle.set(0, leftCoordinate);
        }
        if (rectangle.get(1).compareTo(rectangle.get(3)) > 0) {
            PdfDirectObject bottomCoordinate = rectangle.get(3);
            rectangle.set(3, rectangle.get(1));
            rectangle.set(1, bottomCoordinate);
        }
        return rectangle;
    }

    public Rectangle(RectangularShape rectangle) {
        this(rectangle.getMinX(), rectangle.getMaxY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public Rectangle(Point2D lowerLeft, Point2D upperRight) {
        this(lowerLeft.getX(), upperRight.getY(), upperRight.getX() - lowerLeft.getX(), upperRight.getY() - lowerLeft.getY());
    }

    public Rectangle(double left, double top, double width, double height) {
        this(new PdfArray(PdfReal.get(left), PdfReal.get(top - height), PdfReal.get(left + width), PdfReal.get(top)));
    }

    private Rectangle(PdfDirectObject baseObject) {
        super(Rectangle.normalize((PdfArray)baseObject.resolve()));
    }

    @Override
    public Rectangle clone(Document context) {
        return (Rectangle)super.clone(context);
    }

    public double getBottom() {
        return ((PdfNumber)((PdfArray)this.getBaseDataObject()).get(1)).getDoubleValue();
    }

    public double getHeight() {
        return this.getTop() - this.getBottom();
    }

    public double getLeft() {
        return ((PdfNumber)((PdfArray)this.getBaseDataObject()).get(0)).getDoubleValue();
    }

    public double getRight() {
        return ((PdfNumber)((PdfArray)this.getBaseDataObject()).get(2)).getDoubleValue();
    }

    public double getTop() {
        return ((PdfNumber)((PdfArray)this.getBaseDataObject()).get(3)).getDoubleValue();
    }

    public double getWidth() {
        return this.getRight() - this.getLeft();
    }

    public double getX() {
        return this.getLeft();
    }

    public double getY() {
        return this.getBottom();
    }

    public void setBottom(double value) {
        ((PdfNumber)((PdfArray)this.getBaseDataObject()).get(1)).setValue(value);
    }

    public void setHeight(double value) {
        this.setBottom(this.getTop() - value);
    }

    public void setLeft(double value) {
        ((PdfNumber)((PdfArray)this.getBaseDataObject()).get(0)).setValue(value);
    }

    public void setRight(double value) {
        ((PdfNumber)((PdfArray)this.getBaseDataObject()).get(2)).setValue(value);
    }

    public void setTop(double value) {
        ((PdfNumber)((PdfArray)this.getBaseDataObject()).get(3)).setValue(value);
    }

    public void setWidth(double value) {
        this.setRight(this.getLeft() + value);
    }

    public void setX(double value) {
        this.setLeft(value);
    }

    public void setY(double value) {
        this.setBottom(value);
    }

    public Rectangle2D toRectangle2D() {
        return new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }
}

