/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.objects;

import java.io.UnsupportedEncodingException;
import org.pdfclown.objects.IVisitor;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.objects.PdfString;
import org.pdfclown.tokens.PdfDocEncoding;

public final class PdfTextString
extends PdfString {
    public static final PdfTextString Default = new PdfTextString("");
    private boolean unicoded;

    public static PdfTextString get(String value) {
        return value == null ? null : new PdfTextString(value);
    }

    public PdfTextString(byte[] rawValue) {
        super(rawValue);
    }

    public PdfTextString(String value) {
        super(value);
    }

    public PdfTextString(byte[] rawValue, PdfString.SerializationModeEnum serializationMode) {
        super(rawValue, serializationMode);
    }

    public PdfTextString(String value, PdfString.SerializationModeEnum serializationMode) {
        super(value, serializationMode);
    }

    @Override
    public PdfObject accept(IVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public String getValue() {
        if (this.getSerializationMode() == PdfString.SerializationModeEnum.Literal && this.unicoded) {
            try {
                byte[] valueBytes = (byte[])this.getRawValue();
                return new String(valueBytes, 2, valueBytes.length - 2, "UTF-16BE");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return (String)super.getValue();
    }

    @Override
    protected void setRawValue(byte[] value) {
        this.unicoded = value.length >= 2 && value[0] == -2 && value[1] == -1;
        super.setRawValue(value);
    }

    @Override
    protected void setValue(Object value) {
        switch (this.getSerializationMode()) {
            case Literal: {
                String literalValue = (String)value;
                byte[] valueBytes = PdfDocEncoding.get().encode(literalValue);
                if (valueBytes == null) {
                    try {
                        byte[] valueBaseBytes = literalValue.getBytes("UTF-16BE");
                        valueBytes = new byte[valueBaseBytes.length + 2];
                        valueBytes[0] = -2;
                        valueBytes[1] = -1;
                        System.arraycopy(valueBaseBytes, 0, valueBytes, 2, valueBaseBytes.length);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.setRawValue(valueBytes);
                break;
            }
            case Hex: {
                super.setValue(value);
            }
        }
    }
}

