/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.objects;

import java.io.ByteArrayOutputStream;
import org.pdfclown.bytes.IOutputStream;
import org.pdfclown.files.File;
import org.pdfclown.objects.IVisitor;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.objects.PdfSimpleObject;
import org.pdfclown.tokens.PdfDocEncoding;
import org.pdfclown.util.ConvertUtils;
import org.pdfclown.util.IDataWrapper;
import org.pdfclown.util.NotImplementedException;

public class PdfString
extends PdfSimpleObject<byte[]>
implements IDataWrapper {
    public static final PdfString Default = new PdfString("");
    private static final byte BackspaceCode = 8;
    private static final byte CarriageReturnCode = 13;
    private static final byte FormFeedCode = 12;
    private static final byte HorizontalTabCode = 9;
    private static final byte LineFeedCode = 10;
    private static final byte HexLeftDelimiterCode = 60;
    private static final byte HexRightDelimiterCode = 62;
    private static final byte LiteralEscapeCode = 92;
    private static final byte LiteralLeftDelimiterCode = 40;
    private static final byte LiteralRightDelimiterCode = 41;
    private SerializationModeEnum serializationMode = SerializationModeEnum.Literal;

    public PdfString(byte[] rawValue) {
        this.setRawValue(rawValue);
    }

    public PdfString(String value) {
        this.setValue(value);
    }

    public PdfString(byte[] rawValue, SerializationModeEnum serializationMode) {
        this.setSerializationMode(serializationMode);
        this.setRawValue(rawValue);
    }

    public PdfString(String value, SerializationModeEnum serializationMode) {
        this.setSerializationMode(serializationMode);
        this.setValue(value);
    }

    protected PdfString() {
    }

    @Override
    public PdfObject accept(IVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public int compareTo(PdfDirectObject object) {
        if (!(object instanceof PdfString)) {
            throw new IllegalArgumentException("Object MUST be a PdfString");
        }
        return ((String)this.getValue()).compareTo((String)((PdfString)object).getValue());
    }

    public SerializationModeEnum getSerializationMode() {
        return this.serializationMode;
    }

    public String getStringValue() {
        return (String)this.getValue();
    }

    @Override
    public Object getValue() {
        switch (this.serializationMode) {
            case Literal: {
                return PdfDocEncoding.get().decode((byte[])this.getRawValue());
            }
            case Hex: {
                return ConvertUtils.byteArrayToHex((byte[])this.getRawValue());
            }
        }
        throw new NotImplementedException((Object)((Object)this.serializationMode) + " serialization mode is not implemented.");
    }

    public void setSerializationMode(SerializationModeEnum value) {
        this.serializationMode = value;
    }

    @Override
    public byte[] toByteArray() {
        return (byte[])((byte[])this.getRawValue()).clone();
    }

    @Override
    public String toString() {
        switch (this.serializationMode) {
            case Hex: {
                return "<" + super.toString() + ">";
            }
            case Literal: {
                return "(" + super.toString() + ")";
            }
        }
        throw new NotImplementedException();
    }

    @Override
    public void writeTo(IOutputStream stream, File context) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] rawValue = (byte[])this.getRawValue();
        switch (this.serializationMode) {
            case Literal: {
                buffer.write(40);
                int index = 0;
                while (index < rawValue.length) {
                    int valueByte = rawValue[index];
                    switch (valueByte) {
                        case 10: {
                            buffer.write(92);
                            valueByte = 110;
                            break;
                        }
                        case 13: {
                            buffer.write(92);
                            valueByte = 114;
                            break;
                        }
                        case 9: {
                            buffer.write(92);
                            valueByte = 116;
                            break;
                        }
                        case 8: {
                            buffer.write(92);
                            valueByte = 98;
                            break;
                        }
                        case 12: {
                            buffer.write(92);
                            valueByte = 102;
                            break;
                        }
                        case 40: 
                        case 41: 
                        case 92: {
                            buffer.write(92);
                        }
                    }
                    buffer.write(valueByte);
                    ++index;
                }
                buffer.write(41);
                break;
            }
            case Hex: {
                buffer.write(60);
                byte[] value = PdfDocEncoding.get().encode(ConvertUtils.byteArrayToHex(rawValue));
                buffer.write(value, 0, value.length);
                buffer.write(62);
                break;
            }
            default: {
                throw new NotImplementedException();
            }
        }
        stream.write(buffer.toByteArray());
    }

    @Override
    protected void setValue(Object value) {
        switch (this.serializationMode) {
            case Literal: {
                this.setRawValue(PdfDocEncoding.get().encode((String)value));
                break;
            }
            case Hex: {
                this.setRawValue(ConvertUtils.hexToByteArray((String)value));
                break;
            }
            default: {
                throw new NotImplementedException((Object)((Object)this.serializationMode) + " serialization mode is not implemented.");
            }
        }
    }

    public static enum SerializationModeEnum {
        Literal,
        Hex;

    }
}

