/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.objects;

import java.util.Date;
import org.pdfclown.files.File;
import org.pdfclown.objects.PdfBoolean;
import org.pdfclown.objects.PdfDate;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.objects.PdfReal;
import org.pdfclown.objects.PdfTextString;
import org.pdfclown.util.NotImplementedException;

public abstract class PdfSimpleObject<TValue>
extends PdfDirectObject {
    private TValue value;

    public static PdfSimpleObject<?> get(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return PdfInteger.get((Integer)value);
        }
        if (value instanceof Number) {
            return PdfReal.get((Number)value);
        }
        if (value instanceof String) {
            return PdfTextString.get((String)value);
        }
        if (value instanceof Date) {
            return PdfDate.get((Date)value);
        }
        if (value instanceof Boolean) {
            return PdfBoolean.get((Boolean)value);
        }
        throw new NotImplementedException();
    }

    public static Object getValue(PdfObject object) {
        return PdfSimpleObject.getValue(object, null);
    }

    public static Object getValue(PdfObject object, Object defaultValue) {
        Object value = (object = PdfSimpleObject.resolve(object)) instanceof PdfSimpleObject ? ((PdfSimpleObject)object).getValue() : null;
        return value != null ? value : defaultValue;
    }

    @Override
    public final PdfSimpleObject<TValue> clone(File context) {
        return this;
    }

    public boolean equals(Object object) {
        return super.equals(object) || object != null && object.getClass().equals(this.getClass()) && ((PdfSimpleObject)object).getRawValue().equals(this.getRawValue());
    }

    @Override
    public final PdfObject getParent() {
        return null;
    }

    public TValue getRawValue() {
        return this.value;
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.getRawValue().hashCode();
    }

    @Override
    public final boolean isUpdated() {
        return false;
    }

    @Override
    public final boolean isUpdateable() {
        return false;
    }

    @Override
    public final void setUpdateable(boolean value) {
    }

    @Override
    public PdfSimpleObject<TValue> swap(PdfObject other) {
        throw new UnsupportedOperationException("Immutable object");
    }

    public String toString() {
        return this.getValue().toString();
    }

    @Override
    protected boolean isVirtual() {
        return false;
    }

    protected void setRawValue(TValue value) {
        this.value = value;
    }

    @Override
    protected final void setUpdated(boolean value) {
    }

    protected void setValue(Object value) {
        this.value = value;
    }

    @Override
    protected void setVirtual(boolean value) {
    }

    @Override
    final void setParent(PdfObject value) {
    }
}

