/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.objects;

import org.pdfclown.bytes.IOutputStream;
import org.pdfclown.files.File;
import org.pdfclown.objects.IPdfIndirectObject;
import org.pdfclown.objects.IVisitor;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfIndirectObject;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.tokens.FileParser;
import org.pdfclown.util.NotImplementedException;

public final class PdfReference
extends PdfDirectObject
implements IPdfIndirectObject {
    private PdfIndirectObject indirectObject;
    private int objectNumber;
    private File file;
    private PdfObject parent;
    private boolean updated;

    PdfReference(PdfIndirectObject indirectObject) {
        this.indirectObject = indirectObject;
    }

    public PdfReference(FileParser.Reference reference, File file) {
        this.objectNumber = reference.getObjectNumber();
        this.file = file;
    }

    @Override
    public PdfObject accept(IVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public int compareTo(PdfDirectObject object) {
        throw new NotImplementedException();
    }

    public boolean equals(Object object) {
        return super.equals(object) || object != null && object.getClass().equals(this.getClass()) && ((PdfReference)object).getId().equals(this.getId());
    }

    public int getGenerationNumber() {
        return this.getIndirectObject().getXrefEntry().getGeneration();
    }

    public String getId() {
        return "" + this.getObjectNumber() + ' ' + this.getGenerationNumber();
    }

    public String getIndirectReference() {
        return String.valueOf(this.getId()) + ' ' + 'R';
    }

    public int getObjectNumber() {
        return this.getIndirectObject().getXrefEntry().getNumber();
    }

    @Override
    public PdfObject getParent() {
        return this.parent;
    }

    public int hashCode() {
        return this.getIndirectObject().hashCode();
    }

    @Override
    public boolean isUpdateable() {
        return this.getIndirectObject().isUpdateable();
    }

    @Override
    public boolean isUpdated() {
        return this.updated;
    }

    @Override
    public void setUpdateable(boolean value) {
        this.getIndirectObject().setUpdateable(value);
    }

    @Override
    public PdfReference swap(PdfObject other) {
        return this.getIndirectObject().swap(((PdfReference)other).getIndirectObject()).getReference();
    }

    public String toString() {
        return this.getIndirectReference();
    }

    @Override
    public void writeTo(IOutputStream stream, File context) {
        stream.write(this.getIndirectReference());
    }

    @Override
    public PdfReference clone(File context) {
        return (PdfReference)super.clone(context);
    }

    @Override
    public void delete() {
        this.getIndirectObject().delete();
    }

    @Override
    public PdfDataObject getDataObject() {
        return this.getIndirectObject().getDataObject();
    }

    @Override
    public PdfIndirectObject getIndirectObject() {
        if (this.indirectObject == null) {
            this.indirectObject = this.file.getIndirectObjects().get(this.objectNumber);
        }
        return this.indirectObject;
    }

    @Override
    public PdfReference getReference() {
        return this;
    }

    @Override
    public void setDataObject(PdfDataObject value) {
        this.getIndirectObject().setDataObject(value);
    }

    @Override
    protected boolean isVirtual() {
        return this.getIndirectObject().isVirtual();
    }

    @Override
    protected void setUpdated(boolean value) {
        this.updated = value;
    }

    @Override
    protected void setVirtual(boolean value) {
        this.getIndirectObject().setVirtual(value);
    }

    @Override
    void setParent(PdfObject value) {
        this.parent = value;
    }
}

