/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.objects;

import org.pdfclown.bytes.IOutputStream;
import org.pdfclown.files.File;
import org.pdfclown.objects.IVisitor;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfObject;

public final class PdfReal
extends PdfNumber<Double> {
    public static PdfReal get(Number value) {
        if (value == null) {
            return null;
        }
        double doubleValue = value.doubleValue();
        if (Double.isNaN(doubleValue)) {
            return null;
        }
        return new PdfReal(doubleValue);
    }

    public PdfReal(double value) {
        this.setRawValue(value);
    }

    @Override
    public PdfObject accept(IVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public double getDoubleValue() {
        return (Double)this.getRawValue();
    }

    @Override
    public float getFloatValue() {
        return ((Double)this.getRawValue()).floatValue();
    }

    @Override
    public int getIntValue() {
        return (int)Math.round((Double)this.getRawValue());
    }

    @Override
    public Double getValue() {
        return super.getValue().doubleValue();
    }

    @Override
    public void writeTo(IOutputStream stream, File context) {
        stream.write(context.getConfiguration().getRealFormat().format(this.getRawValue()));
    }

    @Override
    protected void setValue(Object value) {
        super.setValue(((Number)value).doubleValue());
    }
}

