/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.objects;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.pdfclown.objects.IVisitor;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.objects.PdfString;
import org.pdfclown.tokens.PdfDocEncoding;
import org.pdfclown.util.parsers.ParseException;

public final class PdfDate
extends PdfString {
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmssZ");

    public static PdfDate get(Date value) {
        return value == null ? null : new PdfDate(value);
    }

    public static Date toDate(String value) throws ParseException {
        StringBuilder dateBuilder = new StringBuilder();
        try {
            int length = value.length();
            dateBuilder.append(value.substring(2, 6));
            dateBuilder.append(length < 8 ? "01" : value.substring(6, 8));
            dateBuilder.append(length < 10 ? "01" : value.substring(8, 10));
            dateBuilder.append(length < 12 ? "00" : value.substring(10, 12));
            dateBuilder.append(length < 14 ? "00" : value.substring(12, 14));
            dateBuilder.append(length < 16 ? "00" : value.substring(14, 16));
            dateBuilder.append(length < 17 || value.substring(16, 17).equals("Z") ? "+" : value.substring(16, 17));
            dateBuilder.append(length < 19 ? "00" : value.substring(17, 19));
            dateBuilder.append(length < 22 ? "00" : value.substring(20, 22));
        }
        catch (Exception exception) {
            throw new ParseException("Failed to normalize the date string.", exception);
        }
        try {
            return formatter.parse(dateBuilder.toString());
        }
        catch (Exception exception) {
            throw new ParseException("Failed to parse the date string.", exception);
        }
    }

    public PdfDate(Date value) {
        this.setValue(value);
    }

    @Override
    public PdfObject accept(IVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public Date getValue() {
        return PdfDate.toDate((String)super.getValue());
    }

    @Override
    public void setSerializationMode(PdfString.SerializationModeEnum value) {
    }

    @Override
    protected void setValue(Object value) {
        byte[] buffer = new byte[23];
        byte[] valueBytes = PdfDocEncoding.get().encode(formatter.format(value));
        buffer[0] = 68;
        buffer[1] = 58;
        System.arraycopy(valueBytes, 0, buffer, 2, 17);
        buffer[19] = 39;
        System.arraycopy(valueBytes, 17, buffer, 20, 2);
        buffer[22] = 39;
        this.setRawValue(buffer);
    }
}

