/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.pdfclown.bytes.IOutputStream;
import org.pdfclown.files.File;
import org.pdfclown.objects.IVisitor;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfIndirectObject;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.tokens.Chunk;
import org.pdfclown.tokens.Encoding;
import org.pdfclown.tokens.XRefEntry;
import org.pdfclown.util.NotImplementedException;

public final class PdfArray
extends PdfDirectObject
implements List<PdfDirectObject> {
    private static final byte[] BeginArrayChunk = Encoding.Pdf.encode("[");
    private static final byte[] EndArrayChunk = Encoding.Pdf.encode("]");
    ArrayList<PdfDirectObject> items;
    private PdfObject parent;
    private boolean updated;
    private boolean updateable = true;
    private boolean virtual;

    public PdfArray() {
        this(10);
    }

    public PdfArray(int capacity) {
        this.items = new ArrayList(capacity);
    }

    public PdfArray(PdfDirectObject ... items) {
        this(items.length);
        this.setUpdateable(false);
        PdfDirectObject[] pdfDirectObjectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            PdfDirectObject item = pdfDirectObjectArray[n2];
            this.add(item);
            ++n2;
        }
        this.setUpdateable(true);
    }

    public PdfArray(List<? extends PdfDirectObject> items) {
        this(items.size());
        this.setUpdateable(false);
        this.addAll((Collection<? extends PdfDirectObject>)items);
        this.setUpdateable(true);
    }

    @Override
    public PdfObject accept(IVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public PdfArray clone(File context) {
        return (PdfArray)super.clone(context);
    }

    @Override
    public int compareTo(PdfDirectObject obj) {
        throw new NotImplementedException();
    }

    public <T extends PdfDataObject> PdfDirectObject get(int index, Class<T> itemClass) {
        return this.get(index, itemClass, true);
    }

    public <T extends PdfDataObject> PdfDirectObject get(int index, Class<T> itemClass, boolean direct) {
        PdfDirectObject item;
        if (index == this.size() || (item = this.get(index)) == null || !item.resolve().getClass().equals(itemClass)) {
            try {
                item = (PdfDirectObject)this.include(direct ? (PdfDataObject)itemClass.newInstance() : new PdfIndirectObject(this.getFile(), (PdfDataObject)itemClass.newInstance(), new XRefEntry(0, 0)).getReference());
                if (index == this.size()) {
                    this.items.add(item);
                } else if (item == null) {
                    this.items.set(index, item);
                } else {
                    this.items.add(index, item);
                }
                item.setVirtual(true);
            }
            catch (Exception e) {
                throw new RuntimeException(String.valueOf(itemClass.getSimpleName()) + " failed to instantiate.", e);
            }
        }
        return item;
    }

    @Override
    public PdfObject getParent() {
        return this.parent;
    }

    @Override
    public boolean isUpdateable() {
        return this.updateable;
    }

    @Override
    public boolean isUpdated() {
        return this.updated;
    }

    public PdfDataObject resolve(int index) {
        return PdfArray.resolve(this.get(index));
    }

    public <T extends PdfDataObject> T resolve(int index, Class<T> itemClass) {
        return (T)PdfArray.resolve(this.get(index, itemClass));
    }

    @Override
    public void setUpdateable(boolean value) {
        this.updateable = value;
    }

    @Override
    public PdfArray swap(PdfObject other) {
        PdfArray otherArray = (PdfArray)other;
        ArrayList<PdfDirectObject> otherItems = otherArray.items;
        otherArray.items = this.items;
        otherArray.update();
        this.items = otherItems;
        this.update();
        return this;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[ ");
        for (PdfDirectObject item : this.items) {
            buffer.append(PdfDirectObject.toString(item)).append(" ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public void writeTo(IOutputStream stream, File context) {
        stream.write(BeginArrayChunk);
        for (PdfDirectObject item : this.items) {
            if (item != null && item.isVirtual()) continue;
            PdfDirectObject.writeTo(stream, context, item);
            stream.write(Chunk.Space);
        }
        stream.write(EndArrayChunk);
    }

    @Override
    public void add(int index, PdfDirectObject item) {
        this.items.add(index, (PdfDirectObject)this.include(item));
        this.update();
    }

    @Override
    public boolean addAll(int index, Collection<? extends PdfDirectObject> items) {
        for (PdfDirectObject pdfDirectObject : items) {
            this.add(index++, pdfDirectObject);
        }
        return true;
    }

    @Override
    public PdfDirectObject get(int index) {
        return this.items.get(index);
    }

    @Override
    public int indexOf(Object item) {
        return this.items.indexOf(item);
    }

    @Override
    public int lastIndexOf(Object item) {
        return this.items.lastIndexOf(item);
    }

    @Override
    public ListIterator<PdfDirectObject> listIterator() {
        return this.items.listIterator();
    }

    @Override
    public ListIterator<PdfDirectObject> listIterator(int index) {
        return this.items.listIterator(index);
    }

    @Override
    public PdfDirectObject remove(int index) {
        PdfDirectObject oldItem = this.items.remove(index);
        this.exclude(oldItem);
        this.update();
        return oldItem;
    }

    @Override
    public PdfDirectObject set(int index, PdfDirectObject item) {
        item = (PdfDirectObject)this.include(item);
        PdfDirectObject oldItem = this.items.set(index, item);
        this.exclude(oldItem);
        this.update();
        return oldItem;
    }

    @Override
    public List<PdfDirectObject> subList(int fromIndex, int toIndex) {
        return this.items.subList(fromIndex, toIndex);
    }

    @Override
    public boolean add(PdfDirectObject item) {
        item = (PdfDirectObject)this.include(item);
        this.items.add(item);
        this.update();
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends PdfDirectObject> items) {
        for (PdfDirectObject pdfDirectObject : items) {
            this.add(pdfDirectObject);
        }
        return true;
    }

    @Override
    public void clear() {
        while (!this.items.isEmpty()) {
            this.remove(0);
        }
    }

    @Override
    public boolean contains(Object item) {
        return this.items.contains(item);
    }

    @Override
    public boolean containsAll(Collection<?> items) {
        return this.items.containsAll(items);
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) || object != null && object.getClass().equals(this.getClass()) && ((PdfArray)object).items.equals(this.items);
    }

    @Override
    public int hashCode() {
        return this.items.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public boolean remove(Object item) {
        if (!this.items.remove(item)) {
            return false;
        }
        this.exclude((PdfDirectObject)item);
        this.update();
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> items) {
        for (Object item : items) {
            this.remove(item);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> items) {
        int index = 0;
        while (index < this.items.size()) {
            if (!items.contains(this.get(index))) {
                this.remove(index);
                continue;
            }
            ++index;
        }
        return true;
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public Object[] toArray() {
        return this.items.toArray();
    }

    @Override
    public <T> T[] toArray(T[] items) {
        return this.items.toArray(items);
    }

    @Override
    public Iterator<PdfDirectObject> iterator() {
        return this.items.iterator();
    }

    @Override
    protected boolean isVirtual() {
        return this.virtual;
    }

    @Override
    protected void setUpdated(boolean value) {
        this.updated = value;
    }

    @Override
    protected void setVirtual(boolean value) {
        this.virtual = value;
    }

    @Override
    void setParent(PdfObject value) {
        this.parent = value;
    }
}

