/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.files;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.pdfclown.documents.Document;
import org.pdfclown.files.File;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfString;
import org.pdfclown.tokens.Writer;

public final class FileIdentifier
extends PdfObjectWrapper<PdfArray> {
    public static FileIdentifier wrap(PdfDirectObject baseObject) {
        return baseObject != null ? new FileIdentifier(baseObject) : null;
    }

    private static PdfArray createBaseDataObject() {
        return new PdfArray(PdfString.Default, PdfString.Default);
    }

    private static void digest(MessageDigest digest, Object value) throws UnsupportedEncodingException {
        digest.update(value.toString().getBytes("ISO-8859-1"));
    }

    public FileIdentifier() {
        this(FileIdentifier.createBaseDataObject());
    }

    public FileIdentifier(File context) {
        super(context, FileIdentifier.createBaseDataObject());
    }

    private FileIdentifier(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public FileIdentifier clone(Document context) {
        return (FileIdentifier)super.clone(context);
    }

    public String getBaseID() {
        return (String)((PdfString)((PdfArray)this.getBaseDataObject()).get(0)).getValue();
    }

    public String getVersionID() {
        return (String)((PdfString)((PdfArray)this.getBaseDataObject()).get(1)).getValue();
    }

    public void update(Writer writer) {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 algorithm unavailable.", e);
        }
        File file = writer.getFile();
        try {
            FileIdentifier.digest(md5, new Long(System.currentTimeMillis()));
            if (file.getPath() != null) {
                FileIdentifier.digest(md5, file.getPath());
            }
            FileIdentifier.digest(md5, new Long(writer.getStream().getLength()));
            for (Map.Entry<PdfName, PdfDirectObject> informationObjectEntry : ((PdfDictionary)file.getDocument().getInformation().getBaseDataObject()).entrySet()) {
                FileIdentifier.digest(md5, informationObjectEntry.getKey());
                FileIdentifier.digest(md5, informationObjectEntry.getValue());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("File identifier digest failed.", e);
        }
        PdfString versionID = new PdfString(md5.digest(), PdfString.SerializationModeEnum.Hex);
        ((PdfArray)this.getBaseDataObject()).set(1, versionID);
        if (((PdfArray)this.getBaseDataObject()).get(0).equals(PdfString.Default)) {
            ((PdfArray)this.getBaseDataObject()).set(0, versionID);
        }
    }
}

