/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interchange.access;

import java.util.Arrays;
import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfTextString;
import org.pdfclown.util.StringUtils;

@PDF(value=VersionEnum.PDF14)
public final class LanguageIdentifier
extends PdfObjectWrapper<PdfTextString> {
    public static LanguageIdentifier wrap(PdfDirectObject baseObject) {
        if (baseObject == null) {
            return null;
        }
        if (baseObject.resolve() instanceof PdfTextString) {
            return new LanguageIdentifier(baseObject);
        }
        throw new IllegalArgumentException("'baseObject' parameter doesn't represent a valid language identifier object.");
    }

    public LanguageIdentifier(String ... components) {
        this(Arrays.asList(components));
    }

    public LanguageIdentifier(List<String> components) {
        this.setComponents(components);
    }

    LanguageIdentifier(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public LanguageIdentifier clone(Document context) {
        return (LanguageIdentifier)super.clone(context);
    }

    public List<String> getComponents() {
        return Arrays.asList(((PdfTextString)this.getBaseDataObject()).getValue().split("-"));
    }

    public void setComponents(List<String> value) {
        this.setBaseObject(new PdfTextString(StringUtils.join('-', value.toArray(new String[0]))));
    }
}

