/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.navigation.page;

import java.awt.geom.Rectangle2D;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Page;
import org.pdfclown.documents.interaction.navigation.page.Article;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.Rectangle;

@PDF(value=VersionEnum.PDF11)
public class ArticleElement
extends PdfObjectWrapper<PdfDictionary> {
    public static ArticleElement wrap(PdfDirectObject baseObject) {
        return baseObject != null ? new ArticleElement(baseObject) : null;
    }

    public ArticleElement(Page page, Rectangle2D box) {
        super(page.getDocument(), new PdfDictionary(new PdfName[]{PdfName.Type}, new PdfDirectObject[]{PdfName.Bead}));
        page.getArticleElements().add(this);
        this.setBox(box);
    }

    private ArticleElement(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public boolean delete() {
        this.getArticle().getElements().remove(this);
        this.getPage().getArticleElements().remove(this);
        return super.delete();
    }

    public Article getArticle() {
        PdfDictionary bead = (PdfDictionary)this.getBaseDataObject();
        Article article = null;
        while ((article = Article.wrap(bead.get(PdfName.T))) == null) {
            bead = (PdfDictionary)bead.resolve(PdfName.V);
        }
        return article;
    }

    public Rectangle2D getBox() {
        Rectangle box = Rectangle.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.R));
        return new Rectangle2D.Double(box.getLeft(), this.getPage().getBox().getHeight() - box.getTop(), box.getWidth(), box.getHeight());
    }

    public ArticleElement getNext() {
        return ArticleElement.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.N));
    }

    public Page getPage() {
        return Page.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.P));
    }

    public ArticleElement getPrevious() {
        return ArticleElement.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.V));
    }

    public boolean isHead() {
        PdfDictionary thread = (PdfDictionary)((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.T);
        return thread != null && this.getBaseObject().equals(thread.get(PdfName.F));
    }

    public void setBox(Rectangle2D value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.R, (PdfDirectObject)new Rectangle(value.getX(), this.getPage().getBox().getHeight() - value.getY(), value.getWidth(), value.getHeight()).getBaseDataObject());
    }
}

