/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.navigation.document;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.interaction.navigation.document.LocalDestination;
import org.pdfclown.documents.interaction.navigation.document.RemoteDestination;
import org.pdfclown.objects.IPdfNamedObjectWrapper;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfReal;
import org.pdfclown.objects.PdfReference;
import org.pdfclown.objects.PdfSimpleObject;
import org.pdfclown.objects.PdfString;

@PDF(value=VersionEnum.PDF10)
public abstract class Destination
extends PdfObjectWrapper<PdfArray>
implements IPdfNamedObjectWrapper {
    public static final Destination wrap(PdfDirectObject baseObject) {
        if (baseObject == null) {
            return null;
        }
        PdfArray dataObject = (PdfArray)baseObject.resolve();
        PdfDirectObject pageObject = dataObject.get(0);
        if (pageObject instanceof PdfReference) {
            return new LocalDestination(baseObject);
        }
        if (pageObject instanceof PdfInteger) {
            return new RemoteDestination(baseObject);
        }
        throw new IllegalArgumentException("'baseObject' parameter doesn't represent a valid destination object.");
    }

    protected Destination(Document context, Object page, ModeEnum mode, Object location, Double zoom) {
        super(context, new PdfArray(null, null));
        this.setPage(page);
        this.setMode(mode);
        this.setLocation(location);
        this.setZoom(zoom);
    }

    protected Destination(PdfDirectObject baseObject) {
        super(baseObject);
    }

    public Object getLocation() {
        switch (this.getMode()) {
            case FitHorizontal: 
            case FitVertical: 
            case FitBoundingBoxHorizontal: 
            case FitBoundingBoxVertical: {
                return PdfSimpleObject.getValue(((PdfArray)this.getBaseDataObject()).get(2), Double.NaN);
            }
            case FitRectangle: {
                Double left = (Double)PdfSimpleObject.getValue(((PdfArray)this.getBaseDataObject()).get(2), Double.NaN);
                Double top = (Double)PdfSimpleObject.getValue(((PdfArray)this.getBaseDataObject()).get(5), Double.NaN);
                Double width = (Double)PdfSimpleObject.getValue(((PdfArray)this.getBaseDataObject()).get(4), Double.NaN) - left;
                Double height = (Double)PdfSimpleObject.getValue(((PdfArray)this.getBaseDataObject()).get(3), Double.NaN) - top;
                return new Rectangle2D.Double(left, top, width, height);
            }
            case XYZ: {
                return new Point2D.Double((Double)PdfSimpleObject.getValue(((PdfArray)this.getBaseDataObject()).get(2), Double.NaN), (Double)PdfSimpleObject.getValue(((PdfArray)this.getBaseDataObject()).get(3), Double.NaN));
            }
        }
        return null;
    }

    public ModeEnum getMode() {
        return ModeEnum.valueOf((PdfName)((PdfArray)this.getBaseDataObject()).get(1));
    }

    public abstract Object getPage();

    public Double getZoom() {
        switch (this.getMode()) {
            case XYZ: {
                return (Double)PdfSimpleObject.getValue(((PdfArray)this.getBaseDataObject()).get(4));
            }
        }
        return null;
    }

    public void setLocation(Object value) {
        PdfArray baseDataObject = (PdfArray)this.getBaseDataObject();
        switch (this.getMode()) {
            case FitHorizontal: 
            case FitVertical: 
            case FitBoundingBoxHorizontal: 
            case FitBoundingBoxVertical: {
                baseDataObject.set(2, PdfReal.get((Number)value));
                break;
            }
            case FitRectangle: {
                Rectangle2D rectangle = (Rectangle2D)value;
                baseDataObject.set(2, PdfReal.get(rectangle.getMinX()));
                baseDataObject.set(3, PdfReal.get(rectangle.getMinY()));
                baseDataObject.set(4, PdfReal.get(rectangle.getMaxX()));
                baseDataObject.set(5, PdfReal.get(rectangle.getMaxY()));
                break;
            }
            case XYZ: {
                Point2D point = (Point2D)value;
                baseDataObject.set(2, PdfReal.get(point.getX()));
                baseDataObject.set(3, PdfReal.get(point.getY()));
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setMode(ModeEnum value) {
        baseDataObject = (PdfArray)this.getBaseDataObject();
        baseDataObject.set(1, value.getName());
        switch (Destination.$SWITCH_TABLE$org$pdfclown$documents$interaction$navigation$document$Destination$ModeEnum()[value.ordinal()]) {
            case 2: 
            case 6: {
                parametersCount = 2;
                ** GOTO lbl22
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                parametersCount = 3;
                ** GOTO lbl22
            }
            case 1: {
                parametersCount = 5;
                ** GOTO lbl22
            }
            case 5: {
                parametersCount = 6;
                if (true) ** GOTO lbl22
            }
            default: {
                throw new UnsupportedOperationException("Mode unknown: " + (Object)value);
            }
        }
        do {
            baseDataObject.add(null);
lbl22:
            // 5 sources

        } while (baseDataObject.size() < parametersCount);
        while (baseDataObject.size() > parametersCount) {
            baseDataObject.remove(baseDataObject.size() - 1);
        }
    }

    public abstract void setPage(Object var1);

    public void setZoom(Double value) {
        switch (this.getMode()) {
            case XYZ: {
                ((PdfArray)this.getBaseDataObject()).set(4, PdfReal.get(value));
                break;
            }
        }
    }

    @Override
    public PdfString getName() {
        return this.retrieveName();
    }

    @Override
    public PdfDirectObject getNamedBaseObject() {
        return this.retrieveNamedBaseObject();
    }

    public static enum ModeEnum {
        XYZ(PdfName.XYZ),
        Fit(PdfName.Fit),
        FitHorizontal(PdfName.FitH),
        FitVertical(PdfName.FitV),
        FitRectangle(PdfName.FitR),
        FitBoundingBox(PdfName.FitB),
        FitBoundingBoxHorizontal(PdfName.FitBH),
        FitBoundingBoxVertical(PdfName.FitBV);

        private PdfName name;

        private ModeEnum(PdfName name) {
            this.name = name;
        }

        public PdfName getName() {
            return this.name;
        }

        public static ModeEnum valueOf(String string) {
            return Enum.valueOf(ModeEnum.class, string);
        }
    }
}

