/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.forms;

import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.interaction.annotations.DualWidget;
import org.pdfclown.documents.interaction.annotations.Widget;
import org.pdfclown.documents.interaction.forms.ButtonField;
import org.pdfclown.documents.interaction.forms.Field;
import org.pdfclown.documents.interaction.forms.FieldWidgets;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.util.EnumUtils;

@PDF(value=VersionEnum.PDF12)
public final class RadioButton
extends ButtonField {
    public RadioButton(String name, DualWidget[] widgets, String value) {
        super(name, widgets[0]);
        this.setFlags(EnumUtils.mask(EnumUtils.mask(this.getFlags(), Field.FlagsEnum.Radio, true), Field.FlagsEnum.NoToggleToOff, true));
        FieldWidgets fieldWidgets = this.getWidgets();
        int index = 1;
        int length = widgets.length;
        while (index < length) {
            fieldWidgets.add(widgets[index]);
            ++index;
        }
        this.setValue(value);
    }

    RadioButton(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public RadioButton clone(Document context) {
        return (RadioButton)super.clone(context);
    }

    public boolean isToggleable() {
        return !this.getFlags().contains((Object)Field.FlagsEnum.NoToggleToOff);
    }

    public void setToggleable(boolean value) {
        this.setFlags(EnumUtils.mask(this.getFlags(), Field.FlagsEnum.NoToggleToOff, !value));
    }

    @Override
    public void setValue(Object value) {
        PdfName selectedWidgetName = new PdfName((String)value);
        boolean selected = false;
        for (Widget widget : this.getWidgets()) {
            PdfName currentState;
            if (((DualWidget)widget).getWidgetName().equals(value)) {
                selected = true;
                currentState = selectedWidgetName;
            } else {
                currentState = PdfName.Off;
            }
            ((PdfDictionary)widget.getBaseDataObject()).put(PdfName.AS, currentState);
        }
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.V, selected ? selectedWidgetName : null);
    }
}

