/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.forms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.interaction.forms.Field;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfReference;
import org.pdfclown.objects.PdfTextString;
import org.pdfclown.util.NotImplementedException;

@PDF(value=VersionEnum.PDF12)
public final class Fields
extends PdfObjectWrapper<PdfArray>
implements Map<String, Field> {
    public Fields(Document context) {
        super(context, new PdfArray());
    }

    Fields(PdfDirectObject baseObject) {
        super(baseObject);
    }

    public boolean add(Field value) {
        return ((PdfArray)this.getBaseDataObject()).add(value.getBaseObject());
    }

    @Override
    public Fields clone(Document context) {
        return (Fields)super.clone(context);
    }

    @Override
    public void clear() {
        ((PdfArray)this.getBaseDataObject()).clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new NotImplementedException();
    }

    @Override
    public Set<Map.Entry<String, Field>> entrySet() {
        throw new NotImplementedException();
    }

    @Override
    public Field get(Object key) {
        PdfReference valueFieldReference = null;
        Iterator<String> partialNamesIterator = Arrays.asList(((String)key).split("\\.")).iterator();
        Iterator<PdfDirectObject> fieldObjectsIterator = ((PdfArray)this.getBaseDataObject()).iterator();
        while (partialNamesIterator.hasNext()) {
            String partialName = partialNamesIterator.next();
            valueFieldReference = null;
            while (fieldObjectsIterator != null && fieldObjectsIterator.hasNext()) {
                PdfReference fieldReference = (PdfReference)fieldObjectsIterator.next();
                PdfDictionary fieldDictionary = (PdfDictionary)fieldReference.getDataObject();
                PdfTextString fieldName = (PdfTextString)fieldDictionary.get(PdfName.T);
                if (fieldName == null || !fieldName.getValue().equals(partialName)) continue;
                valueFieldReference = fieldReference;
                PdfArray kidFieldObjects = (PdfArray)fieldDictionary.resolve(PdfName.Kids);
                fieldObjectsIterator = kidFieldObjects == null ? null : kidFieldObjects.iterator();
                break;
            }
            if (valueFieldReference == null) break;
        }
        return Field.wrap(valueFieldReference);
    }

    @Override
    public boolean isEmpty() {
        return ((PdfArray)this.getBaseDataObject()).isEmpty();
    }

    @Override
    public Set<String> keySet() {
        throw new NotImplementedException();
    }

    @Override
    public Field put(String key, Field value) {
        throw new NotImplementedException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Field> entries) {
        throw new NotImplementedException();
    }

    @Override
    public Field remove(Object key) {
        Field field = this.get(key);
        if (field == null) {
            return null;
        }
        PdfReference fieldParentReference = (PdfReference)((PdfDictionary)field.getBaseDataObject()).get(PdfName.Parent);
        PdfArray fieldObjects = fieldParentReference == null ? (PdfArray)this.getBaseDataObject() : (PdfArray)((PdfDictionary)fieldParentReference.getDataObject()).resolve(PdfName.Kids);
        return fieldObjects.remove(field.getBaseObject()) ? field : null;
    }

    @Override
    public int size() {
        return this.values().size();
    }

    @Override
    public Collection<Field> values() {
        ArrayList<Field> values = new ArrayList<Field>();
        this.retrieveValues((PdfArray)this.getBaseDataObject(), values);
        return values;
    }

    private void retrieveValues(PdfArray fieldObjects, List<Field> values) {
        for (PdfDirectObject fieldObject : fieldObjects) {
            PdfReference fieldReference = (PdfReference)fieldObject;
            PdfArray kidReferences = (PdfArray)((PdfDictionary)fieldReference.getDataObject()).resolve(PdfName.Kids);
            PdfDictionary kidObject = kidReferences == null ? null : (PdfDictionary)((PdfReference)kidReferences.get(0)).getDataObject();
            if (kidObject == null || !kidObject.containsKey(PdfName.FT) && kidObject.containsKey(PdfName.Subtype) && kidObject.get(PdfName.Subtype).equals(PdfName.Widget)) {
                values.add(Field.wrap(fieldReference));
                continue;
            }
            this.retrieveValues(kidReferences, values);
        }
    }
}

