/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.forms;

import java.util.EnumSet;
import java.util.Stack;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.interaction.annotations.Widget;
import org.pdfclown.documents.interaction.forms.CheckBox;
import org.pdfclown.documents.interaction.forms.ComboBox;
import org.pdfclown.documents.interaction.forms.FieldActions;
import org.pdfclown.documents.interaction.forms.FieldWidgets;
import org.pdfclown.documents.interaction.forms.ListBox;
import org.pdfclown.documents.interaction.forms.PushButton;
import org.pdfclown.documents.interaction.forms.RadioButton;
import org.pdfclown.documents.interaction.forms.SignatureField;
import org.pdfclown.documents.interaction.forms.TextField;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfReference;
import org.pdfclown.objects.PdfSimpleObject;
import org.pdfclown.objects.PdfString;
import org.pdfclown.objects.PdfTextString;
import org.pdfclown.util.EnumUtils;

@PDF(value=VersionEnum.PDF12)
public abstract class Field
extends PdfObjectWrapper<PdfDictionary> {
    public static final Field wrap(PdfReference reference) {
        int fieldFlagsValue;
        if (reference == null) {
            return null;
        }
        PdfDictionary dataObject = (PdfDictionary)reference.getDataObject();
        PdfName fieldType = (PdfName)Field.getInheritableAttribute(dataObject, PdfName.FT);
        PdfInteger fieldFlags = (PdfInteger)Field.getInheritableAttribute(dataObject, PdfName.Ff);
        int n = fieldFlagsValue = fieldFlags == null ? 0 : fieldFlags.getValue();
        if (fieldType.equals(PdfName.Btn)) {
            if ((fieldFlagsValue & FlagsEnum.Pushbutton.getCode()) > 0) {
                return new PushButton(reference);
            }
            if ((fieldFlagsValue & FlagsEnum.Radio.getCode()) > 0) {
                return new RadioButton(reference);
            }
            return new CheckBox(reference);
        }
        if (fieldType.equals(PdfName.Tx)) {
            return new TextField(reference);
        }
        if (fieldType.equals(PdfName.Ch)) {
            if ((fieldFlagsValue & FlagsEnum.Combo.getCode()) > 0) {
                return new ComboBox(reference);
            }
            return new ListBox(reference);
        }
        if (fieldType.equals(PdfName.Sig)) {
            return new SignatureField(reference);
        }
        throw new UnsupportedOperationException("Unknown field type: " + fieldType);
    }

    private static PdfDirectObject getInheritableAttribute(PdfDictionary dictionary, PdfName key) {
        do {
            PdfDirectObject entry;
            if ((entry = dictionary.get(key)) == null) continue;
            return entry;
        } while ((dictionary = (PdfDictionary)dictionary.resolve(PdfName.Parent)) != null);
        if (key.equals(PdfName.Ff)) {
            return PdfInteger.Default;
        }
        return null;
    }

    protected Field(PdfName fieldType, String name, Widget widget) {
        this(widget.getBaseObject());
        PdfDictionary baseDataObject = (PdfDictionary)this.getBaseDataObject();
        baseDataObject.put(PdfName.FT, fieldType);
        baseDataObject.put(PdfName.T, new PdfTextString(name));
    }

    protected Field(PdfDirectObject baseObject) {
        super(baseObject);
    }

    public FieldActions getActions() {
        PdfDirectObject actionsObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.AA);
        return actionsObject != null ? new FieldActions(actionsObject) : null;
    }

    public Object getDefaultValue() {
        PdfSimpleObject defaultValueObject = (PdfSimpleObject)PdfObject.resolve(this.getInheritableAttribute(PdfName.DV));
        return defaultValueObject != null ? defaultValueObject.getValue() : null;
    }

    public EnumSet<FlagsEnum> getFlags() {
        PdfInteger flagsObject = (PdfInteger)PdfObject.resolve(this.getInheritableAttribute(PdfName.Ff));
        return flagsObject != null ? FlagsEnum.toEnumSet((Integer)flagsObject.getRawValue()) : EnumSet.noneOf(FlagsEnum.class);
    }

    public String getFullName() {
        StringBuilder buffer = new StringBuilder();
        Stack<String> partialNameStack = new Stack<String>();
        PdfDictionary parent = (PdfDictionary)this.getBaseDataObject();
        while (parent != null) {
            partialNameStack.push(((PdfTextString)parent.get(PdfName.T)).getValue());
            parent = (PdfDictionary)parent.resolve(PdfName.Parent);
        }
        while (!partialNameStack.isEmpty()) {
            if (buffer.length() > 0) {
                buffer.append('.');
            }
            buffer.append((String)partialNameStack.pop());
        }
        return buffer.toString();
    }

    public String getName() {
        return ((PdfTextString)this.getInheritableAttribute(PdfName.T)).getValue();
    }

    public Object getValue() {
        PdfSimpleObject valueObject = (PdfSimpleObject)PdfObject.resolve(this.getInheritableAttribute(PdfName.V));
        return valueObject != null ? valueObject.getValue() : null;
    }

    public FieldWidgets getWidgets() {
        PdfDirectObject widgetsObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.Kids);
        return new FieldWidgets(widgetsObject != null ? widgetsObject : this.getBaseObject(), this);
    }

    public boolean isExportable() {
        return !this.getFlags().contains((Object)FlagsEnum.NoExport);
    }

    public boolean isReadOnly() {
        return this.getFlags().contains((Object)FlagsEnum.ReadOnly);
    }

    public boolean isRequired() {
        return this.getFlags().contains((Object)FlagsEnum.Required);
    }

    public void setActions(FieldActions value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.AA, value.getBaseObject());
    }

    public void setExportable(boolean value) {
        this.setFlags(EnumUtils.mask(this.getFlags(), FlagsEnum.NoExport, !value));
    }

    public void setFlags(EnumSet<FlagsEnum> value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Ff, PdfInteger.get(FlagsEnum.toInt(value)));
    }

    public void setName(String value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.T, new PdfTextString(value));
    }

    public void setReadOnly(boolean value) {
        this.setFlags(EnumUtils.mask(this.getFlags(), FlagsEnum.ReadOnly, value));
    }

    public void setRequired(boolean value) {
        this.setFlags(EnumUtils.mask(this.getFlags(), FlagsEnum.Required, value));
    }

    public void setValue(Object value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.V, new PdfString((String)value));
    }

    protected PdfString getDefaultAppearanceState() {
        return (PdfString)this.getInheritableAttribute(PdfName.DA);
    }

    protected PdfDirectObject getInheritableAttribute(PdfName key) {
        return Field.getInheritableAttribute((PdfDictionary)this.getBaseDataObject(), key);
    }

    public static enum FlagsEnum {
        ReadOnly(1),
        Required(2),
        NoExport(4),
        Multiline(4096),
        Password(8192),
        NoToggleToOff(16384),
        Radio(32768),
        Pushbutton(65536),
        Combo(131072),
        Edit(262144),
        Sort(524288),
        FileSelect(0x100000),
        MultiSelect(0x200000),
        DoNotSpellCheck(0x400000),
        DoNotScroll(0x800000),
        Comb(0x1000000),
        RichText(0x2000000),
        RadiosInUnison(0x2000000),
        CommitOnSelChange(0x4000000);

        private final int code;

        public static int toInt(EnumSet<FlagsEnum> flags) {
            int flagsMask = 0;
            for (FlagsEnum flag : flags) {
                flagsMask |= flag.getCode();
            }
            return flagsMask;
        }

        public static EnumSet<FlagsEnum> toEnumSet(int flagsMask) {
            EnumSet<FlagsEnum> flags = EnumSet.noneOf(FlagsEnum.class);
            FlagsEnum[] flagsEnumArray = FlagsEnum.values();
            int n = flagsEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                FlagsEnum flag = flagsEnumArray[n2];
                if ((flagsMask & flag.getCode()) > 0) {
                    flags.add(flag);
                }
                ++n2;
            }
            return flags;
        }

        private FlagsEnum(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

