/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.forms;

import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.interaction.forms.ChoiceItems;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfTextString;
import org.pdfclown.util.NotImplementedException;

@PDF(value=VersionEnum.PDF12)
public final class ChoiceItem
extends PdfObjectWrapper<PdfDirectObject> {
    private ChoiceItems items;

    public ChoiceItem(String value) {
        super(new PdfTextString(value));
    }

    public ChoiceItem(Document context, String value, String text) {
        super(context, new PdfArray(new PdfTextString(value), new PdfTextString(text)));
    }

    ChoiceItem(PdfDirectObject baseObject, ChoiceItems items) {
        super(baseObject);
        this.setItems(items);
    }

    @Override
    public ChoiceItem clone(Document context) {
        throw new NotImplementedException();
    }

    public String getText() {
        PdfDirectObject baseDataObject = (PdfDirectObject)this.getBaseDataObject();
        if (baseDataObject instanceof PdfArray) {
            return ((PdfTextString)((PdfArray)baseDataObject).get(1)).getValue();
        }
        return ((PdfTextString)baseDataObject).getValue();
    }

    public String getValue() {
        PdfDirectObject baseDataObject = (PdfDirectObject)this.getBaseDataObject();
        if (baseDataObject instanceof PdfArray) {
            return ((PdfTextString)((PdfArray)baseDataObject).get(0)).getValue();
        }
        return ((PdfTextString)baseDataObject).getValue();
    }

    public void setText(String value) {
        PdfDirectObject baseDataObject = (PdfDirectObject)this.getBaseDataObject();
        if (baseDataObject instanceof PdfTextString) {
            PdfDirectObject oldBaseDataObject = baseDataObject;
            baseDataObject = new PdfArray(oldBaseDataObject);
            this.setBaseObject(baseDataObject);
            ((PdfArray)baseDataObject).add(PdfTextString.Default);
            if (this.items != null) {
                PdfArray itemsObject = (PdfArray)this.items.getBaseDataObject();
                itemsObject.set(itemsObject.indexOf(oldBaseDataObject), baseDataObject);
            }
        }
        ((PdfArray)baseDataObject).set(1, new PdfTextString(value));
    }

    public void setValue(String value) {
        PdfDirectObject baseDataObject = (PdfDirectObject)this.getBaseDataObject();
        if (baseDataObject instanceof PdfArray) {
            ((PdfArray)baseDataObject).set(0, new PdfTextString(value));
        } else {
            this.setBaseObject(new PdfTextString(value));
        }
    }

    void setItems(ChoiceItems value) {
        if (this.items != null) {
            throw new IllegalArgumentException("Item already associated to another choice field.");
        }
        this.items = value;
    }
}

