/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.annotations;

import java.awt.geom.Rectangle2D;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.Page;
import org.pdfclown.documents.interaction.annotations.Annotation;
import org.pdfclown.documents.interaction.annotations.AnnotationActions;
import org.pdfclown.documents.interaction.annotations.AppearanceCharacteristics;
import org.pdfclown.documents.interaction.annotations.DualWidget;
import org.pdfclown.documents.interaction.annotations.WidgetActions;
import org.pdfclown.documents.interaction.forms.CheckBox;
import org.pdfclown.documents.interaction.forms.Field;
import org.pdfclown.documents.interaction.forms.RadioButton;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.util.EnumUtils;

@PDF(value=VersionEnum.PDF12)
public class Widget
extends Annotation {
    public static Widget wrap(PdfDirectObject baseObject, Field field) {
        return field instanceof CheckBox || field instanceof RadioButton ? new DualWidget(baseObject) : new Widget(baseObject);
    }

    public Widget(Page page, Rectangle2D box) {
        super(page, PdfName.Widget, box, null);
        this.setFlags(EnumUtils.mask(this.getFlags(), Annotation.FlagsEnum.Print, true));
    }

    protected Widget(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public Widget clone(Document context) {
        return (Widget)super.clone(context);
    }

    @Override
    public AnnotationActions getActions() {
        PdfDirectObject actionsObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.AA);
        return actionsObject != null ? new WidgetActions(this, actionsObject) : null;
    }

    public AppearanceCharacteristics getAppearanceCharacteristics() {
        return AppearanceCharacteristics.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.MK, PdfDictionary.class));
    }

    public HighlightModeEnum getHighlightMode() {
        PdfName highlightModeObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.H);
        return highlightModeObject != null ? HighlightModeEnum.get(highlightModeObject) : HighlightModeEnum.Invert;
    }

    public void setAppearanceCharacteristics(AppearanceCharacteristics value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.MK, value.getBaseObject());
    }

    public void setHighlightMode(HighlightModeEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.H, value.getCode());
    }

    public static enum HighlightModeEnum {
        None(PdfName.N),
        Invert(PdfName.I),
        Outline(PdfName.O),
        Push(PdfName.P),
        Toggle(PdfName.T);

        private final PdfName code;

        public static HighlightModeEnum get(PdfName value) {
            HighlightModeEnum[] highlightModeEnumArray = HighlightModeEnum.values();
            int n = highlightModeEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                HighlightModeEnum mode = highlightModeEnumArray[n2];
                if (mode.getCode().equals(value)) {
                    return mode;
                }
                ++n2;
            }
            return null;
        }

        private HighlightModeEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }
}

