/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.annotations;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Page;
import org.pdfclown.documents.interaction.annotations.Shape;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfReal;

@PDF(value=VersionEnum.PDF15)
public abstract class VertexShape
extends Shape {
    protected VertexShape(Page page, Rectangle2D box, String text, PdfName subtype) {
        super(page, box, text, subtype);
    }

    protected VertexShape(PdfDirectObject baseObject) {
        super(baseObject);
    }

    public List<Point2D> getVertices() {
        PdfArray verticesObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Vertices);
        ArrayList<Point2D> vertices = new ArrayList<Point2D>();
        double pageHeight = this.getPage().getBox().getHeight();
        int index = 0;
        int length = verticesObject.size();
        while (index < length) {
            vertices.add(new Point2D.Double(((PdfNumber)verticesObject.get(index)).getDoubleValue(), pageHeight - ((PdfNumber)verticesObject.get(index + 1)).getDoubleValue()));
            index += 2;
        }
        return vertices;
    }

    public void setVertices(List<Point2D> value) {
        PdfArray verticesObject = new PdfArray();
        double pageHeight = this.getPage().getBox().getHeight();
        for (Point2D vertex : value) {
            verticesObject.add(PdfReal.get(vertex.getX()));
            verticesObject.add(PdfReal.get(pageHeight - vertex.getY()));
        }
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Vertices, verticesObject);
    }
}

