/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.annotations;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.File;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.Page;
import org.pdfclown.documents.files.EmbeddedFile;
import org.pdfclown.documents.files.FileSpecification;
import org.pdfclown.documents.interaction.actions.Render;
import org.pdfclown.documents.interaction.annotations.Annotation;
import org.pdfclown.documents.interaction.annotations.FileAttachment;
import org.pdfclown.documents.interaction.annotations.Widget;
import org.pdfclown.documents.interaction.forms.TextField;
import org.pdfclown.documents.multimedia.MediaClipData;
import org.pdfclown.documents.multimedia.MediaRendition;
import org.pdfclown.documents.multimedia.Rendition;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfReference;
import org.pdfclown.objects.PdfString;

@PDF(value=VersionEnum.PDF15)
public final class Screen
extends Annotation {
    private static final String PlayerPlaceholder = "%player%";
    private static final String RenderScript = "if(%player%==undefined){var doc = this;var settings={autoPlay:false,visible:false,volume:100,startAt:0};var events=new app.media.Events({afterFocus:function(event){try{if(event.target.isPlaying){event.target.pause();}else{event.target.play();}doc.getField('%player%').setFocus();}catch(e){}},afterReady:function(event){try{event.target.seek(event.target.settings.startAt);event.target.visible=true;}catch(e){}}});var %player%=app.media.openPlayer({settings:settings,events:events});}";

    public Screen(Page page, Rectangle2D box, String text, String mediaPath, String mimeType) {
        this(page, box, text, new File(mediaPath), mimeType);
    }

    public Screen(Page page, Rectangle2D box, String text, File mediaFile, String mimeType) {
        this(page, box, text, new MediaRendition(new MediaClipData(FileSpecification.get(EmbeddedFile.get(page.getDocument(), mediaFile), mediaFile.getName()), mimeType)));
    }

    public Screen(Page page, Rectangle2D box, String text, Rendition rendition) {
        super(page, PdfName.Screen, box, text);
        PdfObjectWrapper<?> data;
        Render render = new Render(this, Render.OperationEnum.PlayResume, rendition);
        String playerReference = "__player" + ((PdfReference)render.getBaseObject()).getObjectNumber();
        this.getDocument().getForm().getFields().add(new TextField(playerReference, new Widget(page, new Rectangle((int)box.getX(), (int)box.getY(), 0, 0)), ""));
        render.setScript(RenderScript.replace(PlayerPlaceholder, playerReference));
        this.getActions().setOnPageOpen(render);
        if (rendition instanceof MediaRendition && (data = ((MediaRendition)rendition).getClip().getData()) instanceof FileSpecification) {
            FileAttachment attachment = new FileAttachment(page, box, text, (FileSpecification)data);
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.T, PdfString.get(((FileSpecification)data).getPath()));
            ((PdfDictionary)attachment.getBaseDataObject()).put(PdfName.AP, new PdfDictionary(new PdfName[]{PdfName.D, PdfName.R, PdfName.N}, new PdfDirectObject[]{new PdfDictionary(), new PdfDictionary(), new PdfDictionary()}));
        }
    }

    Screen(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public Screen clone(Document context) {
        return (Screen)super.clone(context);
    }
}

