/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.annotations;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.Page;
import org.pdfclown.documents.interaction.annotations.Annotation;
import org.pdfclown.objects.PdfBoolean;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;

@PDF(value=VersionEnum.PDF10)
public final class Note
extends Annotation {
    public Note(Page page, Point2D location, String text) {
        super(page, PdfName.Text, new Rectangle2D.Double(location.getX(), location.getY(), 0.0, 0.0), text);
    }

    Note(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public Note clone(Document context) {
        return (Note)super.clone(context);
    }

    public IconTypeEnum getIconType() {
        PdfName nameObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Name);
        if (nameObject == null) {
            return IconTypeEnum.Note;
        }
        return IconTypeEnum.get(nameObject);
    }

    public boolean isOpen() {
        PdfBoolean openObject = (PdfBoolean)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Open);
        return openObject != null ? openObject.getValue() : false;
    }

    public void setIconType(IconTypeEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Name, value.getCode());
    }

    public void setOpen(boolean value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Open, PdfBoolean.get(value));
    }

    public static enum IconTypeEnum {
        Comment(PdfName.Comment),
        Help(PdfName.Help),
        Insert(PdfName.Insert),
        Key(PdfName.Key),
        NewParagraph(PdfName.NewParagraph),
        Note(PdfName.Note),
        Paragraph(PdfName.Paragraph);

        private final PdfName code;

        public static IconTypeEnum get(PdfName value) {
            IconTypeEnum[] iconTypeEnumArray = IconTypeEnum.values();
            int n = iconTypeEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                IconTypeEnum iconType = iconTypeEnumArray[n2];
                if (iconType.getCode().equals(value)) {
                    return iconType;
                }
                ++n2;
            }
            return null;
        }

        private IconTypeEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }
}

