/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.annotations;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.Page;
import org.pdfclown.documents.contents.xObjects.FormXObject;
import org.pdfclown.documents.interaction.annotations.Appearance;
import org.pdfclown.documents.interaction.annotations.AppearanceStates;
import org.pdfclown.documents.interaction.annotations.Widget;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.util.math.geom.Dimension;

@PDF(value=VersionEnum.PDF12)
public final class DualWidget
extends Widget {
    public DualWidget(Page page, Rectangle2D box, String widgetName) {
        super(page, box);
        Appearance appearance = new Appearance(page.getDocument());
        this.setAppearance(appearance);
        AppearanceStates normalAppearance = appearance.getNormal();
        normalAppearance.put(new PdfName(widgetName), new FormXObject(page.getDocument(), Dimension.get(box)));
    }

    DualWidget(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public DualWidget clone(Document context) {
        return (DualWidget)super.clone(context);
    }

    public String getWidgetName() {
        for (Map.Entry<PdfName, FormXObject> normalAppearanceEntry : this.getAppearance().getNormal().entrySet()) {
            PdfName key = normalAppearanceEntry.getKey();
            if (key.equals(PdfName.Off)) continue;
            return key.getValue();
        }
        return null;
    }
}

