/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.annotations;

import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.LineDash;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfReal;

@PDF(value=VersionEnum.PDF11)
public final class Border
extends PdfObjectWrapper<PdfDictionary> {
    private static final LineDash DefaultLineDash = new LineDash(new double[]{3.0});
    private static final StyleEnum DefaultStyle = StyleEnum.Solid;
    private static final double DefaultWidth = 1.0;

    public Border(Document context, double width, StyleEnum style, LineDash pattern) {
        super(context, new PdfDictionary(new PdfName[]{PdfName.Type}, new PdfDirectObject[]{PdfName.Border}));
        this.setWidth(width);
        this.setStyle(style);
        this.setPattern(pattern);
    }

    Border(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public Border clone(Document context) {
        return (Border)super.clone(context);
    }

    public LineDash getPattern() {
        PdfArray dashObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.D);
        if (dashObject == null) {
            return DefaultLineDash;
        }
        double[] dashArray = new double[dashObject.size()];
        int dashIndex = 0;
        int dashLength = dashArray.length;
        while (dashIndex < dashLength) {
            dashArray[dashIndex] = ((PdfNumber)dashObject.get(dashIndex)).getDoubleValue();
            ++dashIndex;
        }
        return new LineDash(dashArray);
    }

    public StyleEnum getStyle() {
        PdfName styleObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.S);
        if (styleObject == null) {
            return DefaultStyle;
        }
        return StyleEnum.get(styleObject);
    }

    public double getWidth() {
        PdfNumber widthObject = (PdfNumber)((PdfDictionary)this.getBaseDataObject()).get(PdfName.W);
        return widthObject == null ? 1.0 : widthObject.getDoubleValue();
    }

    public void setPattern(LineDash value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.D);
        } else {
            PdfArray dashObject = new PdfArray();
            double[] dashArray = value.getDashArray();
            int dashIndex = 0;
            int dashLength = dashArray.length;
            while (dashIndex < dashLength) {
                dashObject.add(PdfReal.get(dashArray[dashIndex]));
                ++dashIndex;
            }
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.D, dashObject);
        }
    }

    public void setStyle(StyleEnum value) {
        if (value == null || value == DefaultStyle) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.S);
        } else {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.S, value.getCode());
        }
    }

    public void setWidth(double value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.W, PdfReal.get(value));
    }

    public static enum StyleEnum {
        Solid(PdfName.S),
        Dashed(PdfName.D),
        Beveled(PdfName.B),
        Inset(PdfName.I),
        Underline(PdfName.U);

        private final PdfName code;

        public static StyleEnum get(PdfName value) {
            StyleEnum[] styleEnumArray = StyleEnum.values();
            int n = styleEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                StyleEnum style = styleEnumArray[n2];
                if (style.getCode().equals(value)) {
                    return style;
                }
                ++n2;
            }
            return null;
        }

        private StyleEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }
}

