/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.annotations;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.xObjects.FormXObject;
import org.pdfclown.documents.interaction.annotations.Appearance;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfStream;
import org.pdfclown.util.MapEntry;
import org.pdfclown.util.NotImplementedException;

@PDF(value=VersionEnum.PDF12)
public final class AppearanceStates
extends PdfObjectWrapper<PdfDataObject>
implements Map<PdfName, FormXObject> {
    private final Appearance appearance;
    private final PdfName statesKey;

    AppearanceStates(PdfName statesKey, Appearance appearance) {
        super(((PdfDictionary)appearance.getBaseDataObject()).get(statesKey));
        this.appearance = appearance;
        this.statesKey = statesKey;
    }

    @Override
    public AppearanceStates clone(Document context) {
        throw new NotImplementedException();
    }

    public Appearance getAppearance() {
        return this.appearance;
    }

    @Override
    public void clear() {
        this.ensureDictionary().clear();
    }

    @Override
    public boolean containsKey(Object key) {
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject == null) {
            return false;
        }
        if (baseDataObject instanceof PdfStream) {
            return key == null;
        }
        return ((PdfDictionary)baseDataObject).containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (!(value instanceof FormXObject)) {
            return false;
        }
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject == null) {
            return false;
        }
        if (baseDataObject instanceof PdfStream) {
            return ((FormXObject)value).getBaseObject().equals(this.getBaseObject());
        }
        return ((PdfDictionary)baseDataObject).containsValue(((FormXObject)value).getBaseObject());
    }

    @Override
    public Set<Map.Entry<PdfName, FormXObject>> entrySet() {
        HashSet<Map.Entry<PdfName, FormXObject>> entrySet = new HashSet<Map.Entry<PdfName, FormXObject>>();
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject != null) {
            if (baseDataObject instanceof PdfStream) {
                entrySet.add(new MapEntry<Object, FormXObject>(null, FormXObject.wrap(this.getBaseObject())));
            } else {
                for (Map.Entry<PdfName, PdfDirectObject> entry : ((PdfDictionary)baseDataObject).entrySet()) {
                    entrySet.add(new MapEntry<PdfName, FormXObject>(entry.getKey(), FormXObject.wrap(entry.getValue())));
                }
            }
        }
        return entrySet;
    }

    @Override
    public boolean equals(Object object) {
        throw new NotImplementedException();
    }

    @Override
    public FormXObject get(Object key) {
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject == null) {
            return null;
        }
        if (key == null) {
            if (baseDataObject instanceof PdfStream) {
                return FormXObject.wrap(this.getBaseObject());
            }
            return null;
        }
        return FormXObject.wrap(((PdfDictionary)baseDataObject).get(key));
    }

    @Override
    public int hashCode() {
        throw new NotImplementedException();
    }

    @Override
    public boolean isEmpty() {
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject == null) {
            return true;
        }
        if (baseDataObject instanceof PdfStream) {
            return false;
        }
        return ((PdfDictionary)baseDataObject).isEmpty();
    }

    @Override
    public Set<PdfName> keySet() {
        throw new NotImplementedException();
    }

    @Override
    public FormXObject put(PdfName key, FormXObject value) {
        PdfDirectObject previousValue;
        if (key == null) {
            this.setBaseObject(value.getBaseObject());
            previousValue = ((PdfDictionary)this.appearance.getBaseDataObject()).put(this.statesKey, this.getBaseObject());
        } else {
            previousValue = this.ensureDictionary().put(key, value.getBaseObject());
        }
        if (PdfObject.resolve(previousValue) instanceof PdfStream) {
            return FormXObject.wrap(previousValue);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends PdfName, ? extends FormXObject> entries) {
        throw new NotImplementedException();
    }

    @Override
    public FormXObject remove(Object key) {
        PdfDirectObject previousValue;
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject == null) {
            return null;
        }
        if (baseDataObject instanceof PdfStream) {
            if (key == null) {
                this.setBaseObject(null);
                previousValue = ((PdfDictionary)this.appearance.getBaseDataObject()).remove(this.statesKey);
            } else {
                previousValue = null;
            }
        } else {
            previousValue = ((PdfDictionary)baseDataObject).remove(key);
        }
        if (PdfObject.resolve(previousValue) instanceof PdfStream) {
            return FormXObject.wrap(previousValue);
        }
        return null;
    }

    @Override
    public int size() {
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject == null) {
            return 0;
        }
        if (baseDataObject instanceof PdfStream) {
            return 1;
        }
        return ((PdfDictionary)baseDataObject).size();
    }

    @Override
    public Collection<FormXObject> values() {
        throw new NotImplementedException();
    }

    private PdfDictionary ensureDictionary() {
        Object baseDataObject = this.getBaseDataObject();
        if (!(baseDataObject instanceof PdfDictionary)) {
            baseDataObject = new PdfDictionary();
            this.setBaseObject((PdfDirectObject)baseDataObject);
            ((PdfDictionary)this.appearance.getBaseDataObject()).put(this.statesKey, (PdfDictionary)baseDataObject);
        }
        return (PdfDictionary)baseDataObject;
    }
}

