/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.annotations;

import java.awt.geom.Rectangle2D;
import java.util.Date;
import java.util.EnumSet;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.Page;
import org.pdfclown.documents.contents.PropertyList;
import org.pdfclown.documents.contents.colorSpaces.DeviceColor;
import org.pdfclown.documents.contents.layers.ILayerable;
import org.pdfclown.documents.contents.layers.LayerEntity;
import org.pdfclown.documents.interaction.actions.Action;
import org.pdfclown.documents.interaction.annotations.AnnotationActions;
import org.pdfclown.documents.interaction.annotations.Appearance;
import org.pdfclown.documents.interaction.annotations.Border;
import org.pdfclown.documents.interaction.annotations.CalloutNote;
import org.pdfclown.documents.interaction.annotations.Caret;
import org.pdfclown.documents.interaction.annotations.Ellipse;
import org.pdfclown.documents.interaction.annotations.FileAttachment;
import org.pdfclown.documents.interaction.annotations.Line;
import org.pdfclown.documents.interaction.annotations.Link;
import org.pdfclown.documents.interaction.annotations.Movie;
import org.pdfclown.documents.interaction.annotations.Note;
import org.pdfclown.documents.interaction.annotations.Polygon;
import org.pdfclown.documents.interaction.annotations.Polyline;
import org.pdfclown.documents.interaction.annotations.Popup;
import org.pdfclown.documents.interaction.annotations.Rectangle;
import org.pdfclown.documents.interaction.annotations.RubberStamp;
import org.pdfclown.documents.interaction.annotations.Screen;
import org.pdfclown.documents.interaction.annotations.Scribble;
import org.pdfclown.documents.interaction.annotations.Sound;
import org.pdfclown.documents.interaction.annotations.TextMarkup;
import org.pdfclown.documents.interaction.annotations.Widget;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDate;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfSimpleObject;
import org.pdfclown.objects.PdfTextString;
import org.pdfclown.util.EnumUtils;

@PDF(value=VersionEnum.PDF10)
public class Annotation
extends PdfObjectWrapper<PdfDictionary>
implements ILayerable {
    public static final Annotation wrap(PdfDirectObject baseObject) {
        if (baseObject == null) {
            return null;
        }
        PdfName annotationType = (PdfName)((PdfDictionary)baseObject.resolve()).get(PdfName.Subtype);
        if (annotationType.equals(PdfName.Text)) {
            return new Note(baseObject);
        }
        if (annotationType.equals(PdfName.Link)) {
            return new Link(baseObject);
        }
        if (annotationType.equals(PdfName.FreeText)) {
            return new CalloutNote(baseObject);
        }
        if (annotationType.equals(PdfName.Line)) {
            return new Line(baseObject);
        }
        if (annotationType.equals(PdfName.Square)) {
            return new Rectangle(baseObject);
        }
        if (annotationType.equals(PdfName.Circle)) {
            return new Ellipse(baseObject);
        }
        if (annotationType.equals(PdfName.Polygon)) {
            return new Polygon(baseObject);
        }
        if (annotationType.equals(PdfName.PolyLine)) {
            return new Polyline(baseObject);
        }
        if (annotationType.equals(PdfName.Highlight) || annotationType.equals(PdfName.Underline) || annotationType.equals(PdfName.Squiggly) || annotationType.equals(PdfName.StrikeOut)) {
            return new TextMarkup(baseObject);
        }
        if (annotationType.equals(PdfName.Stamp)) {
            return new RubberStamp(baseObject);
        }
        if (annotationType.equals(PdfName.Caret)) {
            return new Caret(baseObject);
        }
        if (annotationType.equals(PdfName.Ink)) {
            return new Scribble(baseObject);
        }
        if (annotationType.equals(PdfName.Popup)) {
            return new Popup(baseObject);
        }
        if (annotationType.equals(PdfName.FileAttachment)) {
            return new FileAttachment(baseObject);
        }
        if (annotationType.equals(PdfName.Sound)) {
            return new Sound(baseObject);
        }
        if (annotationType.equals(PdfName.Movie)) {
            return new Movie(baseObject);
        }
        if (annotationType.equals(PdfName.Widget)) {
            return new Widget(baseObject);
        }
        if (annotationType.equals(PdfName.Screen)) {
            return new Screen(baseObject);
        }
        return new Annotation(baseObject);
    }

    protected Annotation(Page page, PdfName subtype, Rectangle2D box, String text) {
        super(page.getDocument(), new PdfDictionary(new PdfName[]{PdfName.Type, PdfName.Subtype, PdfName.Border}, new PdfDirectObject[]{PdfName.Annot, subtype, new PdfArray(PdfInteger.Default, PdfInteger.Default, PdfInteger.Default)}));
        page.getAnnotations().add(this);
        this.setBox(box);
        this.setText(text);
    }

    protected Annotation(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public Annotation clone(Document context) {
        return (Annotation)super.clone(context);
    }

    @Override
    public boolean delete() {
        this.getPage().getAnnotations().remove(this);
        return super.delete();
    }

    @PDF(value=VersionEnum.PDF11)
    public Action getAction() {
        return Action.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.A));
    }

    @PDF(value=VersionEnum.PDF12)
    public AnnotationActions getActions() {
        return new AnnotationActions(this, ((PdfDictionary)this.getBaseDataObject()).get(PdfName.AA, PdfDictionary.class));
    }

    @PDF(value=VersionEnum.PDF12)
    public Appearance getAppearance() {
        return Appearance.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.AP, PdfDictionary.class));
    }

    @PDF(value=VersionEnum.PDF11)
    public Border getBorder() {
        return new Border(((PdfDictionary)this.getBaseDataObject()).get(PdfName.BS, PdfDictionary.class));
    }

    public Rectangle2D getBox() {
        org.pdfclown.objects.Rectangle box = org.pdfclown.objects.Rectangle.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.Rect));
        return new Rectangle2D.Double(box.getLeft(), this.getPageHeight() - box.getTop(), box.getWidth(), box.getHeight());
    }

    @PDF(value=VersionEnum.PDF11)
    public DeviceColor getColor() {
        return DeviceColor.get((PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.C));
    }

    @PDF(value=VersionEnum.PDF11)
    public EnumSet<FlagsEnum> getFlags() {
        PdfInteger flagsObject = (PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.F);
        return flagsObject == null ? EnumSet.noneOf(FlagsEnum.class) : FlagsEnum.toEnumSet(flagsObject.getValue());
    }

    @PDF(value=VersionEnum.PDF11)
    public Date getModificationDate() {
        PdfDirectObject modificationDateObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.M);
        return modificationDateObject instanceof PdfDate ? ((PdfDate)modificationDateObject).getValue() : null;
    }

    @PDF(value=VersionEnum.PDF14)
    public String getName() {
        return (String)PdfSimpleObject.getValue(((PdfDictionary)this.getBaseDataObject()).get(PdfName.NM));
    }

    @PDF(value=VersionEnum.PDF13)
    public Page getPage() {
        return Page.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.P));
    }

    public String getText() {
        return (String)PdfSimpleObject.getValue(((PdfDictionary)this.getBaseDataObject()).get(PdfName.Contents));
    }

    @PDF(value=VersionEnum.PDF11)
    public boolean isPrintable() {
        return this.getFlags().contains((Object)FlagsEnum.Print);
    }

    @PDF(value=VersionEnum.PDF11)
    public boolean isVisible() {
        return !this.getFlags().contains((Object)FlagsEnum.Hidden);
    }

    public void setAction(Action value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.A, PdfObjectWrapper.getBaseObject(value));
    }

    public void setActions(AnnotationActions value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.AA, PdfObjectWrapper.getBaseObject(value));
    }

    public void setAppearance(Appearance value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.AP, PdfObjectWrapper.getBaseObject(value));
    }

    public void setBorder(Border value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.BS, PdfObjectWrapper.getBaseObject(value));
        if (value != null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.Border);
        }
    }

    public void setBox(Rectangle2D value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Rect, (PdfDirectObject)new org.pdfclown.objects.Rectangle(value.getX(), this.getPageHeight() - value.getY(), value.getWidth(), value.getHeight()).getBaseDataObject());
    }

    public void setColor(DeviceColor value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.C, PdfObjectWrapper.getBaseObject(value));
    }

    public void setFlags(EnumSet<FlagsEnum> value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.F, PdfInteger.get(FlagsEnum.toInt(value)));
    }

    public void setModificationDate(Date value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.M, PdfDate.get(value));
    }

    public void setName(String value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.NM, PdfTextString.get(value));
    }

    public void setPrintable(boolean value) {
        this.setFlags(EnumUtils.mask(this.getFlags(), FlagsEnum.Print, value));
    }

    public void setText(String value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Contents, PdfTextString.get(value));
    }

    public void setVisible(boolean value) {
        this.setFlags(EnumUtils.mask(this.getFlags(), FlagsEnum.Hidden, !value));
    }

    @Override
    @PDF(value=VersionEnum.PDF15)
    public LayerEntity getLayer() {
        return (LayerEntity)PropertyList.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.OC));
    }

    @Override
    public void setLayer(LayerEntity value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.OC, PdfObjectWrapper.getBaseObject(value));
    }

    private double getPageHeight() {
        Page page = this.getPage();
        return page != null ? page.getBox().getHeight() : this.getDocument().getSize().getHeight();
    }

    public static enum FlagsEnum {
        Invisible(1),
        Hidden(2),
        Print(4),
        NoZoom(8),
        NoRotate(16),
        NoView(32),
        ReadOnly(64),
        Locked(128),
        ToggleNoView(256);

        private final int code;

        public static int toInt(EnumSet<FlagsEnum> flags) {
            int flagsMask = 0;
            for (FlagsEnum flag : flags) {
                flagsMask |= flag.getCode();
            }
            return flagsMask;
        }

        public static EnumSet<FlagsEnum> toEnumSet(int flagsMask) {
            EnumSet<FlagsEnum> flags = EnumSet.noneOf(FlagsEnum.class);
            FlagsEnum[] flagsEnumArray = FlagsEnum.values();
            int n = flagsEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                FlagsEnum flag = flagsEnumArray[n2];
                if ((flagsMask & flag.getCode()) > 0) {
                    flags.add(flag);
                }
                ++n2;
            }
            return flags;
        }

        private FlagsEnum(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

