/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.actions;

import java.util.ArrayList;
import java.util.Collection;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.interaction.actions.Action;
import org.pdfclown.documents.interaction.annotations.Annotation;
import org.pdfclown.documents.interaction.forms.Field;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfBoolean;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfReference;
import org.pdfclown.objects.PdfTextString;

@PDF(value=VersionEnum.PDF12)
public final class ToggleVisibility
extends Action {
    public ToggleVisibility(Document context, Collection<PdfObjectWrapper<?>> objects, boolean visible) {
        super(context, PdfName.Hide);
        this.setObjects(objects);
        this.setVisible(visible);
    }

    ToggleVisibility(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public ToggleVisibility clone(Document context) {
        return (ToggleVisibility)super.clone(context);
    }

    public Collection<PdfObjectWrapper<?>> getObjects() {
        ArrayList objects = new ArrayList();
        PdfDirectObject objectsObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.T);
        this.fillObjects(objectsObject, objects);
        return objects;
    }

    public boolean isVisible() {
        PdfBoolean hideObject = (PdfBoolean)((PdfDictionary)this.getBaseDataObject()).get(PdfName.H);
        return hideObject != null ? !hideObject.getValue().booleanValue() : false;
    }

    public void setObjects(Collection<PdfObjectWrapper<?>> value) {
        PdfArray objectsDataObject = new PdfArray();
        for (PdfObjectWrapper<?> item : value) {
            if (item instanceof Annotation) {
                objectsDataObject.add(item.getBaseObject());
                continue;
            }
            if (item instanceof Field) {
                objectsDataObject.add(new PdfTextString(((Field)item).getFullName()));
                continue;
            }
            throw new IllegalArgumentException("Invalid 'Hide' action target type (" + item.getClass().getName() + ").\n" + "It MUST be either an annotation or a form field.");
        }
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.T, objectsDataObject);
    }

    public void setVisible(boolean value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.H, PdfBoolean.get(!value));
    }

    private void fillObjects(PdfDataObject objectObject, Collection<PdfObjectWrapper<?>> objects) {
        PdfDataObject objectDataObject = PdfObject.resolve(objectObject);
        if (objectDataObject instanceof PdfArray) {
            for (PdfDirectObject itemObject : (PdfArray)objectDataObject) {
                this.fillObjects(itemObject, objects);
            }
        } else if (objectDataObject instanceof PdfDictionary) {
            objects.add(Annotation.wrap((PdfReference)objectObject));
        } else if (objectDataObject instanceof PdfTextString) {
            objects.add(this.getDocument().getForm().getFields().get(((PdfTextString)objectDataObject).getValue()));
        } else {
            throw new RuntimeException("Invalid 'Hide' action target type (" + objectDataObject.getClass().getName() + ").\n" + "It should be either an annotation or a form field.");
        }
    }
}

