/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.actions;

import java.util.HashMap;
import java.util.Map;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.interaction.actions.Action;
import org.pdfclown.documents.interaction.actions.JavaScript;
import org.pdfclown.documents.interaction.annotations.Annotation;
import org.pdfclown.documents.interaction.annotations.Screen;
import org.pdfclown.documents.multimedia.Rendition;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;

@PDF(value=VersionEnum.PDF15)
public final class Render
extends Action {
    public Render(Screen screen, OperationEnum operation, Rendition rendition) {
        super(screen.getDocument(), PdfName.Rendition);
        this.setOperation(operation);
        this.setScreen(screen);
        this.setRendition(rendition);
    }

    Render(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public Render clone(Document context) {
        return (Render)super.clone(context);
    }

    public OperationEnum getOperation() {
        return OperationEnum.valueOf((PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.OP));
    }

    public Rendition getRendition() {
        return Rendition.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.R));
    }

    public Screen getScreen() {
        return (Screen)Annotation.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.AN));
    }

    public String getScript() {
        return JavaScript.getScript((PdfDictionary)this.getBaseDataObject(), PdfName.JS);
    }

    public void setOperation(OperationEnum value) {
        PdfDictionary baseDataObject = (PdfDictionary)this.getBaseDataObject();
        if (value == null && baseDataObject.get(PdfName.JS) == null) {
            throw new IllegalArgumentException("Operation MUST be defined.");
        }
        baseDataObject.put(PdfName.OP, value != null ? value.getCode() : null);
    }

    public void setRendition(Rendition value) {
        OperationEnum operation;
        if (value == null && (operation = this.getOperation()) != null) {
            switch (operation) {
                case Play: 
                case PlayResume: {
                    throw new IllegalArgumentException("Rendition MUST be defined.");
                }
            }
        }
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.R, PdfObjectWrapper.getBaseObject(value));
    }

    public void setScreen(Screen value) {
        OperationEnum operation;
        if (value == null && (operation = this.getOperation()) != null) {
            switch (operation) {
                case Play: 
                case Stop: 
                case Pause: 
                case Resume: 
                case PlayResume: {
                    throw new IllegalArgumentException("Screen MUST be defined.");
                }
            }
        }
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.AN, PdfObjectWrapper.getBaseObject(value));
    }

    public void setScript(String value) {
        PdfDictionary baseDataObject = (PdfDictionary)this.getBaseDataObject();
        if (value == null && baseDataObject.get(PdfName.OP) == null) {
            throw new IllegalArgumentException("Script MUST be defined.");
        }
        JavaScript.setScript(baseDataObject, PdfName.JS, value);
    }

    public static enum OperationEnum {
        Play(new PdfInteger(0)),
        Stop(new PdfInteger(1)),
        Pause(new PdfInteger(2)),
        Resume(new PdfInteger(3)),
        PlayResume(new PdfInteger(4));

        private static Map<PdfInteger, OperationEnum> map;
        private final PdfInteger code;

        static {
            map = new HashMap<PdfInteger, OperationEnum>();
            OperationEnum[] operationEnumArray = OperationEnum.values();
            int n = operationEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                OperationEnum value = operationEnumArray[n2];
                map.put(value.getCode(), value);
                ++n2;
            }
        }

        private OperationEnum(PdfInteger code) {
            this.code = code;
        }

        public PdfInteger getCode() {
            return this.code;
        }

        public static OperationEnum valueOf(String string) {
            return Enum.valueOf(OperationEnum.class, string);
        }
    }
}

