/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.functions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.functions.Function;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfStream;
import org.pdfclown.util.math.Interval;

@PDF(value=VersionEnum.PDF12)
public final class Type0Function
extends Function<PdfStream> {
    Type0Function(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public double[] calculate(double[] inputs) {
        return null;
    }

    @Override
    public Type0Function clone(Document context) {
        return (Type0Function)super.clone(context);
    }

    public List<Interval<Integer>> getDomainEncodes() {
        return this.getIntervals(PdfName.Encode, new Function.IDefaultIntervalsCallback<Integer>(){

            @Override
            public List<Interval<Integer>> invoke(List<Interval<Integer>> intervals) {
                for (Integer sampleCount : Type0Function.this.getSampleCounts()) {
                    intervals.add(new Interval<Integer>(0, sampleCount - 1));
                }
                return intervals;
            }
        });
    }

    public InterpolationOrderEnum getOrder() {
        PdfInteger interpolationOrderObject = (PdfInteger)this.getDictionary().get(PdfName.Order);
        return interpolationOrderObject == null ? InterpolationOrderEnum.Linear : InterpolationOrderEnum.get((Integer)interpolationOrderObject.getRawValue());
    }

    public List<Interval<Double>> getRangeDecodes() {
        return this.getIntervals(PdfName.Decode, null);
    }

    public int getSampleBitsCount() {
        return (Integer)((PdfInteger)this.getDictionary().get(PdfName.BitsPerSample)).getRawValue();
    }

    public List<Integer> getSampleCounts() {
        ArrayList<Integer> sampleCounts = new ArrayList<Integer>();
        PdfArray sampleCountsObject = (PdfArray)this.getDictionary().get(PdfName.Size);
        for (PdfDirectObject sampleCountObject : sampleCountsObject) {
            sampleCounts.add((Integer)((PdfInteger)sampleCountObject).getRawValue());
        }
        return sampleCounts;
    }

    public static enum InterpolationOrderEnum {
        Linear(1),
        Cubic(3);

        private static final Map<Integer, InterpolationOrderEnum> values;
        private int code;

        static {
            values = new HashMap<Integer, InterpolationOrderEnum>();
            InterpolationOrderEnum[] interpolationOrderEnumArray = InterpolationOrderEnum.values();
            int n = interpolationOrderEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                InterpolationOrderEnum value = interpolationOrderEnumArray[n2];
                values.put(value.getCode(), value);
                ++n2;
            }
        }

        public static InterpolationOrderEnum get(int code) {
            return values.get(code);
        }

        private InterpolationOrderEnum(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

