/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.tokens;

import java.io.EOFException;
import java.util.ArrayList;
import java.util.List;
import org.pdfclown.bytes.Buffer;
import org.pdfclown.bytes.IInputStream;
import org.pdfclown.documents.contents.objects.BeginInlineImage;
import org.pdfclown.documents.contents.objects.BeginMarkedContent;
import org.pdfclown.documents.contents.objects.BeginSubpath;
import org.pdfclown.documents.contents.objects.BeginText;
import org.pdfclown.documents.contents.objects.ContentObject;
import org.pdfclown.documents.contents.objects.DrawRectangle;
import org.pdfclown.documents.contents.objects.EndInlineImage;
import org.pdfclown.documents.contents.objects.EndMarkedContent;
import org.pdfclown.documents.contents.objects.EndText;
import org.pdfclown.documents.contents.objects.InlineImage;
import org.pdfclown.documents.contents.objects.InlineImageBody;
import org.pdfclown.documents.contents.objects.InlineImageHeader;
import org.pdfclown.documents.contents.objects.LocalGraphicsState;
import org.pdfclown.documents.contents.objects.MarkedContent;
import org.pdfclown.documents.contents.objects.Operation;
import org.pdfclown.documents.contents.objects.PaintPath;
import org.pdfclown.documents.contents.objects.PaintShading;
import org.pdfclown.documents.contents.objects.PaintXObject;
import org.pdfclown.documents.contents.objects.Path;
import org.pdfclown.documents.contents.objects.RestoreGraphicsState;
import org.pdfclown.documents.contents.objects.SaveGraphicsState;
import org.pdfclown.documents.contents.objects.Shading;
import org.pdfclown.documents.contents.objects.Text;
import org.pdfclown.documents.contents.objects.XObject;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfString;
import org.pdfclown.tokens.BaseParser;
import org.pdfclown.tokens.Encoding;
import org.pdfclown.util.parsers.ParseException;
import org.pdfclown.util.parsers.PostScriptParser;

public final class ContentParser
extends BaseParser {
    public ContentParser(IInputStream stream) {
        super(stream);
    }

    public ContentParser(byte[] data) {
        super(data);
    }

    public ContentObject parseContentObject() {
        Operation operation = this.parseOperation();
        if (operation instanceof PaintXObject) {
            return new XObject((PaintXObject)operation);
        }
        if (operation instanceof PaintShading) {
            return new Shading((PaintShading)operation);
        }
        if (operation instanceof BeginSubpath || operation instanceof DrawRectangle) {
            return this.parsePath(operation);
        }
        if (operation instanceof BeginText) {
            return new Text(this.parseContentObjects());
        }
        if (operation instanceof SaveGraphicsState) {
            return new LocalGraphicsState(this.parseContentObjects());
        }
        if (operation instanceof BeginMarkedContent) {
            return new MarkedContent((BeginMarkedContent)operation, this.parseContentObjects());
        }
        if (operation instanceof BeginInlineImage) {
            return this.parseInlineImage();
        }
        return operation;
    }

    public List<ContentObject> parseContentObjects() {
        ArrayList<ContentObject> contentObjects = new ArrayList<ContentObject>();
        while (this.moveNext()) {
            ContentObject contentObject = this.parseContentObject();
            if (contentObject instanceof EndText || contentObject instanceof RestoreGraphicsState || contentObject instanceof EndMarkedContent || contentObject instanceof EndInlineImage) {
                return contentObjects;
            }
            contentObjects.add(contentObject);
        }
        return contentObjects;
    }

    public Operation parseOperation() {
        String operator = null;
        ArrayList<PdfDirectObject> operands = new ArrayList<PdfDirectObject>();
        do {
            switch (this.getTokenType()) {
                case Keyword: {
                    operator = (String)this.getToken();
                    break;
                }
                default: {
                    operands.add(this.parsePdfObject());
                }
            }
        } while (operator == null && this.moveNext());
        return Operation.get(operator, operands);
    }

    @Override
    public PdfDirectObject parsePdfObject() {
        switch (this.getTokenType()) {
            case Literal: {
                if (!(this.getToken() instanceof String)) break;
                return new PdfString(Encoding.Pdf.encode((String)this.getToken()), PdfString.SerializationModeEnum.Literal);
            }
            case Hex: {
                return new PdfString((String)this.getToken(), PdfString.SerializationModeEnum.Hex);
            }
        }
        return (PdfDirectObject)super.parsePdfObject();
    }

    private InlineImage parseInlineImage() {
        ArrayList<PdfDirectObject> operands = new ArrayList<PdfDirectObject>();
        while (this.moveNext() && this.getTokenType() != PostScriptParser.TokenTypeEnum.Keyword) {
            operands.add(this.parsePdfObject());
        }
        InlineImageHeader header = new InlineImageHeader(operands);
        IInputStream stream = this.getStream();
        this.moveNext();
        Buffer data = new Buffer();
        try {
            int prevByte = 0;
            while (true) {
                byte curByte = stream.readByte();
                if (prevByte != 69 || curByte != 73) {
                    byte by = curByte;
                    prevByte = by;
                    data.append(by);
                    continue;
                }
                break;
            }
        }
        catch (EOFException e) {
            throw new ParseException(e);
        }
        InlineImageBody body = new InlineImageBody(data);
        return new InlineImage(header, body);
    }

    private Path parsePath(Operation beginOperation) {
        ArrayList<ContentObject> operations = new ArrayList<ContentObject>();
        operations.add(beginOperation);
        long position = this.getPosition();
        boolean closeable = false;
        while (this.moveNext()) {
            Operation operation = this.parseOperation();
            if (operation instanceof PaintPath) {
                closeable = true;
            } else if (closeable) {
                this.seek(position);
                break;
            }
            operations.add(operation);
            position = this.getPosition();
        }
        return new Path(operations);
    }
}

