/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.objects;

import java.awt.geom.AffineTransform;
import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.contents.ContentScanner;
import org.pdfclown.documents.contents.objects.Operation;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfReal;

@PDF(value=VersionEnum.PDF10)
public final class TranslateTextRelative
extends Operation {
    public static final String SimpleOperator = "Td";
    public static final String LeadOperator = "TD";

    public TranslateTextRelative(double offsetX, double offsetY) {
        this(offsetX, offsetY, false);
    }

    public TranslateTextRelative(double offsetX, double offsetY, boolean leadSet) {
        super(leadSet ? LeadOperator : SimpleOperator, PdfReal.get(offsetX), PdfReal.get(offsetY));
    }

    public TranslateTextRelative(String operator, List<PdfDirectObject> operands) {
        super(operator, operands);
    }

    public double getOffsetX() {
        return ((PdfNumber)this.operands.get(0)).getDoubleValue();
    }

    public double getOffsetY() {
        return ((PdfNumber)this.operands.get(1)).getDoubleValue();
    }

    public boolean isLeadSet() {
        return this.operator.equals(LeadOperator);
    }

    @Override
    public void scan(ContentScanner.GraphicsState state) {
        state.getTlm().translate(this.getOffsetX(), this.getOffsetY());
        state.setTm((AffineTransform)state.getTlm().clone());
        if (this.isLeadSet()) {
            state.setLead(this.getOffsetY());
        }
    }

    public void setLeadSet(boolean value) {
        this.operator = value ? LeadOperator : SimpleOperator;
    }

    public void setOffsetX(double value) {
        this.operands.set(0, PdfReal.get(value));
    }

    public void setOffsetY(double value) {
        this.operands.set(1, PdfReal.get(value));
    }
}

