/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.objects;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.contents.objects.ShowText;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfReal;
import org.pdfclown.objects.PdfSimpleObject;
import org.pdfclown.objects.PdfString;

@PDF(value=VersionEnum.PDF10)
public final class ShowAdjustedText
extends ShowText {
    public static final String Operator = "TJ";

    public ShowAdjustedText(List<Object> value, int reserved) {
        super(Operator);
        this.setValue(value);
    }

    public ShowAdjustedText(List<PdfDirectObject> operands) {
        super(Operator, operands);
    }

    @Override
    public byte[] getText() {
        ByteArrayOutputStream textStream = new ByteArrayOutputStream();
        for (PdfDirectObject element : (PdfArray)this.operands.get(0)) {
            if (!(element instanceof PdfString)) continue;
            try {
                textStream.write((byte[])((PdfString)element).getRawValue());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return textStream.toByteArray();
    }

    @Override
    public List<Object> getValue() {
        ArrayList<Object> value = new ArrayList<Object>();
        for (PdfDirectObject element : (PdfArray)this.operands.get(0)) {
            value.add(((PdfSimpleObject)element).getRawValue());
        }
        return value;
    }

    @Override
    public void setText(byte[] value) {
        this.setValue(Arrays.asList(new Object[]{value}));
    }

    @Override
    public void setValue(List<Object> value) {
        PdfArray elements = new PdfArray();
        this.operands.set(0, elements);
        boolean textItemExpected = true;
        for (Object valueItem : value) {
            PdfSimpleObject element = textItemExpected ? new PdfString((byte[])valueItem) : PdfReal.get((Double)valueItem);
            elements.add(element);
            boolean bl = textItemExpected = !textItemExpected;
        }
    }
}

