/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.objects;

import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.contents.ContentScanner;
import org.pdfclown.documents.contents.IContentContext;
import org.pdfclown.documents.contents.colorSpaces.ColorSpace;
import org.pdfclown.documents.contents.colorSpaces.DeviceCMYKColorSpace;
import org.pdfclown.documents.contents.colorSpaces.DeviceGrayColorSpace;
import org.pdfclown.documents.contents.colorSpaces.DeviceRGBColorSpace;
import org.pdfclown.documents.contents.colorSpaces.PatternColorSpace;
import org.pdfclown.documents.contents.objects.IResourceReference;
import org.pdfclown.documents.contents.objects.Operation;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;

@PDF(value=VersionEnum.PDF11)
public final class SetStrokeColorSpace
extends Operation
implements IResourceReference<ColorSpace<?>> {
    public static final String Operator = "CS";

    public SetStrokeColorSpace(PdfName name) {
        super(Operator, (PdfDirectObject)name);
    }

    public SetStrokeColorSpace(List<PdfDirectObject> operands) {
        super(Operator, operands);
    }

    public ColorSpace<?> getColorSpace(IContentContext context) {
        return this.getResource(context);
    }

    @Override
    public void scan(ContentScanner.GraphicsState state) {
        state.setStrokeColorSpace(this.getColorSpace(state.getScanner().getContentContext()));
        state.setStrokeColor(state.getStrokeColorSpace().getDefaultColor());
    }

    @Override
    public PdfName getName() {
        return (PdfName)this.operands.get(0);
    }

    @Override
    public ColorSpace<?> getResource(IContentContext context) {
        PdfName name = this.getName();
        if (name.equals(PdfName.DeviceGray)) {
            return DeviceGrayColorSpace.Default;
        }
        if (name.equals(PdfName.DeviceRGB)) {
            return DeviceRGBColorSpace.Default;
        }
        if (name.equals(PdfName.DeviceCMYK)) {
            return DeviceCMYKColorSpace.Default;
        }
        if (name.equals(PdfName.Pattern)) {
            return PatternColorSpace.Default;
        }
        return (ColorSpace)context.getResources().getColorSpaces().get(name);
    }

    @Override
    public void setName(PdfName value) {
        this.operands.set(0, value);
    }
}

