/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.objects;

import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.contents.ContentScanner;
import org.pdfclown.documents.contents.LineDash;
import org.pdfclown.documents.contents.objects.Operation;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfReal;

@PDF(value=VersionEnum.PDF10)
public final class SetLineDash
extends Operation {
    public static final String Operator = "d";

    public SetLineDash(LineDash lineDash) {
        super(Operator, (PdfDirectObject)new PdfArray());
        this.setValue(lineDash);
    }

    public SetLineDash(List<PdfDirectObject> operands) {
        super(Operator, operands);
    }

    @Override
    public void scan(ContentScanner.GraphicsState state) {
        state.setLineDash(this.getValue());
    }

    public LineDash getValue() {
        PdfArray baseDashArray = (PdfArray)this.operands.get(0);
        double[] dashArray = new double[baseDashArray.size()];
        int index = 0;
        int length = dashArray.length;
        while (index < length) {
            dashArray[index] = ((PdfNumber)baseDashArray.get(index)).getDoubleValue();
            ++index;
        }
        double dashPhase = ((PdfNumber)this.operands.get(1)).getDoubleValue();
        return new LineDash(dashArray, dashPhase);
    }

    public void setValue(LineDash value) {
        this.operands.clear();
        double[] dashArray = value.getDashArray();
        PdfArray baseDashArray = new PdfArray(dashArray.length);
        double[] dArray = dashArray;
        int n = dashArray.length;
        int n2 = 0;
        while (n2 < n) {
            double dashItem = dArray[n2];
            baseDashArray.add(PdfReal.get(dashItem));
            ++n2;
        }
        this.operands.add(baseDashArray);
        this.operands.add(PdfReal.get(value.getDashPhase()));
    }
}

