/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.objects;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.bytes.IOutputStream;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.ContentScanner;
import org.pdfclown.documents.contents.objects.ContainerObject;
import org.pdfclown.documents.contents.objects.ContentObject;
import org.pdfclown.tokens.Encoding;

@PDF(value=VersionEnum.PDF10)
public final class LocalGraphicsState
extends ContainerObject {
    public static final String BeginOperator = "q";
    public static final String EndOperator = "Q";
    private static final byte[] BeginChunk = Encoding.Pdf.encode("q\n");
    private static final byte[] EndChunk = Encoding.Pdf.encode("Q\n");

    public LocalGraphicsState() {
    }

    public LocalGraphicsState(List<ContentObject> objects) {
        super(objects);
    }

    @Override
    public void scan(ContentScanner.GraphicsState state) {
        Graphics2D context = state.getScanner().getRenderContext();
        if (context != null) {
            Shape clip = context.getClip();
            this.render(state);
            context.setClip(clip);
            context.setTransform(state.getCtm());
        }
    }

    @Override
    public void writeTo(IOutputStream stream, Document context) {
        stream.write(BeginChunk);
        super.writeTo(stream, context);
        stream.write(EndChunk);
    }
}

