/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.objects;

import java.awt.geom.Path2D;
import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.contents.ContentScanner;
import org.pdfclown.documents.contents.objects.Operation;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfReal;

@PDF(value=VersionEnum.PDF10)
public final class DrawRectangle
extends Operation {
    public static final String Operator = "re";

    public DrawRectangle(double x, double y, double width, double height) {
        super(Operator, PdfReal.get(x), PdfReal.get(y), PdfReal.get(width), PdfReal.get(height));
    }

    public DrawRectangle(List<PdfDirectObject> operands) {
        super(Operator, operands);
    }

    public double getHeight() {
        return ((PdfNumber)this.operands.get(3)).getDoubleValue();
    }

    public double getWidth() {
        return ((PdfNumber)this.operands.get(2)).getDoubleValue();
    }

    public double getX() {
        return ((PdfNumber)this.operands.get(0)).getDoubleValue();
    }

    public double getY() {
        return ((PdfNumber)this.operands.get(1)).getDoubleValue();
    }

    @Override
    public void scan(ContentScanner.GraphicsState state) {
        Path2D pathObject = (Path2D)state.getScanner().getRenderObject();
        if (pathObject != null) {
            double x = this.getX();
            double y = this.getY();
            double width = this.getWidth();
            double height = this.getHeight();
            pathObject.moveTo(x, y);
            pathObject.lineTo(x + width, y);
            pathObject.lineTo(x + width, y + height);
            pathObject.lineTo(x, y + height);
            pathObject.closePath();
        }
    }

    public void setHeight(double value) {
        this.operands.set(3, PdfReal.get(value));
    }

    public void setWidth(double value) {
        this.operands.set(2, PdfReal.get(value));
    }

    public void setX(double value) {
        this.operands.set(0, PdfReal.get(value));
    }

    public void setY(double value) {
        this.operands.set(1, PdfReal.get(value));
    }
}

