/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.objects;

import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.contents.ContentScanner;
import org.pdfclown.documents.contents.objects.Operation;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfReal;

@PDF(value=VersionEnum.PDF10)
public final class DrawCurve
extends Operation {
    public static final String FinalOperator = "v";
    public static final String FullOperator = "c";
    public static final String InitialOperator = "y";

    public DrawCurve(Point2D point, Point2D control1, Point2D control2) {
        this(point.getX(), point.getY(), control1.getX(), control1.getY(), control2.getX(), control2.getY());
    }

    public DrawCurve(double pointX, double pointY, double control1X, double control1Y, double control2X, double control2Y) {
        super(FullOperator, PdfReal.get(control1X), PdfReal.get(control1Y), PdfReal.get(control2X), PdfReal.get(control2Y), PdfReal.get(pointX), PdfReal.get(pointY));
    }

    public DrawCurve(Point2D point, Point2D control, String operator) {
        super(operator.equals(InitialOperator) ? InitialOperator : FinalOperator, PdfReal.get(control.getX()), PdfReal.get(control.getY()), PdfReal.get(point.getX()), PdfReal.get(point.getY()));
    }

    public DrawCurve(String operator, List<PdfDirectObject> operands) {
        super(operator, operands);
    }

    public Point2D getControl1() {
        if (this.operator.equals(FinalOperator)) {
            return null;
        }
        return new Point2D.Double(((PdfNumber)this.operands.get(0)).getDoubleValue(), ((PdfNumber)this.operands.get(1)).getDoubleValue());
    }

    public Point2D getControl2() {
        if (this.operator.equals(FinalOperator)) {
            return new Point2D.Double(((PdfNumber)this.operands.get(0)).getDoubleValue(), ((PdfNumber)this.operands.get(1)).getDoubleValue());
        }
        return new Point2D.Double(((PdfNumber)this.operands.get(2)).getDoubleValue(), ((PdfNumber)this.operands.get(3)).getDoubleValue());
    }

    public Point2D getPoint() {
        if (this.operator.equals(FullOperator)) {
            return new Point2D.Double(((PdfNumber)this.operands.get(4)).getDoubleValue(), ((PdfNumber)this.operands.get(5)).getDoubleValue());
        }
        return new Point2D.Double(((PdfNumber)this.operands.get(2)).getDoubleValue(), ((PdfNumber)this.operands.get(3)).getDoubleValue());
    }

    @Override
    public void scan(ContentScanner.GraphicsState state) {
        Path2D pathObject = (Path2D)state.getScanner().getRenderObject();
        if (pathObject != null) {
            Point2D controlPoint1 = this.getControl1();
            if (controlPoint1 == null) {
                controlPoint1 = pathObject.getCurrentPoint();
            }
            Point2D finalPoint = this.getPoint();
            Point2D controlPoint2 = this.getControl2();
            if (controlPoint2 == null) {
                controlPoint2 = finalPoint;
            }
            pathObject.curveTo(controlPoint1.getX(), controlPoint1.getY(), controlPoint2.getX(), controlPoint2.getY(), finalPoint.getX(), finalPoint.getY());
        }
    }

    public void setControl1(Point2D value) {
        if (this.operator.equals(FinalOperator)) {
            this.operator = FullOperator;
            this.operands.add(0, PdfReal.get(value.getX()));
            this.operands.add(1, PdfReal.get(value.getY()));
        } else {
            this.operands.set(0, PdfReal.get(value.getX()));
            this.operands.set(1, PdfReal.get(value.getY()));
        }
    }

    public void setControl2(Point2D value) {
        if (this.operator.equals(FinalOperator)) {
            this.operands.set(0, PdfReal.get(value.getX()));
            this.operands.set(1, PdfReal.get(value.getY()));
        } else {
            this.operands.set(2, PdfReal.get(value.getX()));
            this.operands.set(3, PdfReal.get(value.getY()));
        }
    }

    public void setPoint(Point2D value) {
        if (this.operator.equals(FullOperator)) {
            this.operands.set(4, PdfReal.get(value.getX()));
            this.operands.set(5, PdfReal.get(value.getY()));
        } else {
            this.operands.set(2, PdfReal.get(value.getX()));
            this.operands.set(3, PdfReal.get(value.getY()));
        }
    }
}

