/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.fonts;

import java.util.Hashtable;
import java.util.Map;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.fonts.AfmParser;
import org.pdfclown.documents.contents.fonts.CffParser;
import org.pdfclown.documents.contents.fonts.Encoding;
import org.pdfclown.documents.contents.fonts.PfbParser;
import org.pdfclown.documents.contents.fonts.SimpleFont;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfStream;
import org.pdfclown.util.BiMap;
import org.pdfclown.util.ByteArray;
import org.pdfclown.util.ConvertUtils;
import org.pdfclown.util.NotImplementedException;

@PDF(value=VersionEnum.PDF10)
public class Type1Font
extends SimpleFont {
    protected AfmParser.FontMetrics metrics;

    Type1Font(Document context) {
        super(context);
    }

    Type1Font(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public Type1Font clone(Document context) {
        return (Type1Font)super.clone(context);
    }

    protected Map<ByteArray, Integer> getNativeEncoding() {
        PdfDictionary descriptor = this.getDescriptor();
        if (descriptor.containsKey(PdfName.FontFile)) {
            PdfStream fontFileStream = (PdfStream)descriptor.resolve(PdfName.FontFile);
            PfbParser parser = new PfbParser(fontFileStream.getBody());
            return parser.parse();
        }
        if (descriptor.containsKey(PdfName.FontFile3)) {
            PdfStream fontFileStream = (PdfStream)descriptor.resolve(PdfName.FontFile3);
            PdfName fontFileSubtype = (PdfName)fontFileStream.getHeader().get(PdfName.Subtype);
            if (fontFileSubtype.equals(PdfName.Type1C)) {
                CffParser parser = new CffParser(fontFileStream.getBody());
                Hashtable<ByteArray, Integer> codes = new Hashtable<ByteArray, Integer>();
                for (Map.Entry<Integer, Integer> glyphIndexEntry : parser.glyphIndexes.entrySet()) {
                    codes.put(new ByteArray(new byte[]{ConvertUtils.intToByteArray(glyphIndexEntry.getValue())[3]}), glyphIndexEntry.getKey());
                }
                return codes;
            }
            if (fontFileSubtype.equals(PdfName.OpenType)) {
                throw new NotImplementedException("Embedded OpenFont/CFF font file.");
            }
            throw new UnsupportedOperationException("Unsupported embedded font file format: " + fontFileSubtype);
        }
        return Encoding.get(PdfName.StandardEncoding).getCodes();
    }

    @Override
    protected void loadEncoding() {
        if (this.codes == null) {
            Map<ByteArray, Integer> codes;
            PdfDataObject encodingObject = ((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.Encoding);
            if (encodingObject == null) {
                codes = this.getNativeEncoding();
            } else if (encodingObject instanceof PdfName) {
                codes = Encoding.get((PdfName)encodingObject).getCodes();
            } else {
                PdfDictionary encodingDictionary = (PdfDictionary)encodingObject;
                PdfName baseEncodingName = (PdfName)encodingDictionary.get(PdfName.BaseEncoding);
                codes = baseEncodingName == null ? this.getNativeEncoding() : Encoding.get(baseEncodingName).getCodes();
                this.loadEncodingDifferences(encodingDictionary, codes);
            }
            this.codes = new BiMap<ByteArray, Integer>(codes);
        }
        if (this.glyphIndexes == null) {
            this.glyphIndexes = new Hashtable();
            for (Map.Entry codeEntry : this.codes.entrySet()) {
                this.glyphIndexes.put((Integer)codeEntry.getValue(), ConvertUtils.byteArrayToInt(((ByteArray)codeEntry.getKey()).data));
            }
        }
    }
}

