/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.fonts;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.fonts.Encoding;
import org.pdfclown.documents.contents.fonts.Font;
import org.pdfclown.documents.contents.fonts.OpenFontParser;
import org.pdfclown.documents.contents.fonts.SimpleFont;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfStream;
import org.pdfclown.util.BiMap;
import org.pdfclown.util.ByteArray;

@PDF(value=VersionEnum.PDF10)
public final class TrueTypeFont
extends SimpleFont {
    TrueTypeFont(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public TrueTypeFont clone(Document context) {
        return (TrueTypeFont)super.clone(context);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void loadEncoding() {
        OpenFontParser parser;
        PdfDictionary descriptor = this.getDescriptor();
        if (descriptor.containsKey(PdfName.FontFile2)) {
            PdfStream pdfStream = (PdfStream)descriptor.resolve(PdfName.FontFile2);
            parser = new OpenFontParser(pdfStream.getBody());
        } else if (descriptor.containsKey(PdfName.FontFile3)) {
            PdfStream pdfStream = (PdfStream)descriptor.resolve(PdfName.FontFile3);
            PdfName pdfName = (PdfName)pdfStream.getHeader().get(PdfName.Subtype);
            if (!pdfName.equals(PdfName.OpenType)) throw new UnsupportedOperationException("Unknown embedded font file format: " + pdfName);
            parser = new OpenFontParser(pdfStream.getBody());
        } else {
            parser = null;
        }
        if (parser != null) {
            this.glyphIndexes = parser.glyphIndexes;
            if (this.codes != null && parser.metrics.isCustomEncoding) {
                Hashtable<Integer, Integer> unicodeGlyphIndexes = new Hashtable<Integer, Integer>();
                for (Map.Entry entry : this.glyphIndexes.entrySet()) {
                    Integer code = (Integer)this.codes.get(new ByteArray(new byte[]{(byte)((Integer)entry.getKey()).intValue()}));
                    if (code == null) continue;
                    unicodeGlyphIndexes.put(code, (Integer)entry.getValue());
                }
                this.glyphIndexes = unicodeGlyphIndexes;
            }
        }
        PdfDataObject encodingObject = ((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.Encoding);
        EnumSet<Font.FlagsEnum> enumSet = this.getFlags();
        if (enumSet.contains((Object)Font.FlagsEnum.Symbolic) || !enumSet.contains((Object)Font.FlagsEnum.Nonsymbolic) && encodingObject == null) {
            this.symbolic = true;
            if (this.glyphIndexes == null) {
                this.glyphIndexes = new Hashtable();
                PdfArray pdfArray = (PdfArray)((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.Widths);
                if (pdfArray != null) {
                    int code = (Integer)((PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.FirstChar)).getRawValue();
                    for (Object glyphWidthObject : pdfArray) {
                        if ((Integer)((PdfInteger)glyphWidthObject).getRawValue() > 0) {
                            this.glyphIndexes.put(code, code);
                        }
                        ++code;
                    }
                }
            }
            if (this.codes != null) return;
            HashMap<ByteArray, Integer> hashMap = new HashMap<ByteArray, Integer>();
            for (Map.Entry glyphIndexEntry : this.glyphIndexes.entrySet()) {
                if ((Integer)glyphIndexEntry.getValue() <= 0) continue;
                int glyphCharCode = (Integer)glyphIndexEntry.getKey();
                byte[] charCode = new byte[]{(byte)glyphCharCode};
                hashMap.put(new ByteArray(charCode), glyphCharCode);
            }
            this.codes = new BiMap(hashMap);
            return;
        } else {
            this.symbolic = false;
            if (this.codes == null) {
                void var4_20;
                if (encodingObject == null) {
                    Map<ByteArray, Integer> map = Encoding.get(PdfName.StandardEncoding).getCodes();
                } else if (encodingObject instanceof PdfName) {
                    Map<ByteArray, Integer> map = Encoding.get((PdfName)encodingObject).getCodes();
                } else {
                    void var4_19;
                    PdfDictionary encodingDictionary = (PdfDictionary)encodingObject;
                    PdfName baseEncodingName = (PdfName)encodingDictionary.get(PdfName.BaseEncoding);
                    if (baseEncodingName == null) {
                        Map<ByteArray, Integer> map = Encoding.get(PdfName.StandardEncoding).getCodes();
                    } else {
                        Map<ByteArray, Integer> map = Encoding.get(baseEncodingName).getCodes();
                    }
                    this.loadEncodingDifferences(encodingDictionary, (Map<ByteArray, Integer>)var4_19);
                }
                this.codes = new BiMap(var4_20);
            }
            if (this.glyphIndexes != null) return;
            this.glyphIndexes = new Hashtable();
            PdfArray pdfArray = (PdfArray)((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.Widths);
            if (pdfArray == null) return;
            ByteArray charCode = new ByteArray(new byte[]{(byte)((Integer)((PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.FirstChar)).getRawValue()).intValue()});
            for (PdfDirectObject glyphWidthObject : pdfArray) {
                Integer code;
                if ((Integer)((PdfInteger)glyphWidthObject).getRawValue() > 0 && (code = (Integer)this.codes.get(charCode)) != null) {
                    this.glyphIndexes.put(code, Integer.valueOf(charCode.data[0]));
                }
                charCode.data[0] = (byte)(charCode.data[0] + 1);
            }
        }
    }
}

