/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.fonts;

import java.io.BufferedReader;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import org.pdfclown.bytes.Buffer;
import org.pdfclown.bytes.IInputStream;
import org.pdfclown.documents.contents.fonts.GlyphMapping;
import org.pdfclown.util.ByteArray;
import org.pdfclown.util.ConvertUtils;
import org.pdfclown.util.math.OperationUtils;
import org.pdfclown.util.parsers.PostScriptParser;

final class CMapParser
extends PostScriptParser {
    private static final String BeginBaseFontCharOperator = "beginbfchar";
    private static final String BeginBaseFontRangeOperator = "beginbfrange";
    private static final String BeginCIDCharOperator = "begincidchar";
    private static final String BeginCIDRangeOperator = "begincidrange";

    public CMapParser(BufferedReader stream) {
        this(new Buffer(stream));
    }

    public CMapParser(InputStream stream) {
        this(new Buffer(stream));
    }

    public CMapParser(IInputStream stream) {
        super(stream);
    }

    public Map<ByteArray, Integer> parse() {
        this.getStream().setPosition(0L);
        Hashtable<ByteArray, Integer> codes = new Hashtable<ByteArray, Integer>();
        int itemCount = 0;
        block7: while (this.moveNext()) {
            switch (this.getTokenType()) {
                case Keyword: {
                    int itemIndex;
                    String operator = (String)this.getToken();
                    if (operator.equals(BeginBaseFontCharOperator) || operator.equals(BeginCIDCharOperator)) {
                        itemIndex = 0;
                        while (itemIndex < itemCount) {
                            this.moveNext();
                            ByteArray inputCode = new ByteArray(this.parseInputCode());
                            this.moveNext();
                            codes.put(inputCode, this.parseUnicode());
                            ++itemIndex;
                        }
                        continue block7;
                    }
                    if (!operator.equals(BeginBaseFontRangeOperator) && !operator.equals(BeginCIDRangeOperator)) continue block7;
                    itemIndex = 0;
                    while (itemIndex < itemCount) {
                        this.moveNext();
                        byte[] beginInputCode = this.parseInputCode();
                        this.moveNext();
                        byte[] endInputCode = this.parseInputCode();
                        this.moveNext();
                        block4 : switch (this.getTokenType()) {
                            case ArrayBegin: {
                                byte[] inputCode = beginInputCode;
                                while (this.moveNext() && this.getTokenType() != PostScriptParser.TokenTypeEnum.ArrayEnd) {
                                    codes.put(new ByteArray(inputCode), this.parseUnicode());
                                    OperationUtils.increment(inputCode);
                                }
                                break;
                            }
                            default: {
                                byte[] inputCode = beginInputCode;
                                int charCode = this.parseUnicode();
                                int endCharCode = charCode + (ConvertUtils.byteArrayToInt(endInputCode) - ConvertUtils.byteArrayToInt(beginInputCode));
                                while (true) {
                                    codes.put(new ByteArray(inputCode), charCode);
                                    if (charCode == endCharCode) break block4;
                                    OperationUtils.increment(inputCode);
                                    ++charCode;
                                }
                            }
                        }
                        ++itemIndex;
                    }
                    continue block7;
                }
                case Integer: {
                    itemCount = (Integer)this.getToken();
                }
            }
        }
        return codes;
    }

    private byte[] parseInputCode() {
        return ConvertUtils.hexToByteArray((String)this.getToken());
    }

    private int parseUnicode() {
        switch (this.getTokenType()) {
            case Hex: {
                return Integer.parseInt((String)this.getToken(), 16);
            }
            case Integer: {
                return (Integer)this.getToken();
            }
            case Name: {
                return GlyphMapping.nameToCode((String)this.getToken());
            }
        }
        throw new RuntimeException("Hex string, integer or name expected instead of " + (Object)((Object)this.getTokenType()));
    }
}

