/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.entities;

import java.io.EOFException;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.pdfclown.bytes.Buffer;
import org.pdfclown.bytes.IInputStream;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.composition.PrimitiveComposer;
import org.pdfclown.documents.contents.entities.Image;
import org.pdfclown.documents.contents.objects.ContentObject;
import org.pdfclown.documents.contents.objects.InlineImage;
import org.pdfclown.documents.contents.objects.InlineImageBody;
import org.pdfclown.documents.contents.objects.InlineImageHeader;
import org.pdfclown.documents.contents.xObjects.ImageXObject;
import org.pdfclown.documents.contents.xObjects.XObject;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfStream;

public final class JpegImage
extends Image {
    JpegImage(IInputStream stream) {
        super(stream);
        this.load();
    }

    @Override
    public ContentObject toInlineObject(PrimitiveComposer composer) {
        return composer.add(new InlineImage(new InlineImageHeader(Arrays.asList(PdfName.W, PdfInteger.get(this.getWidth()), PdfName.H, PdfInteger.get(this.getHeight()), PdfName.CS, PdfName.RGB, PdfName.BPC, PdfInteger.get(this.getBitsPerComponent()), PdfName.F, PdfName.DCT)), new InlineImageBody(new Buffer(this.getStream().toByteArray()))));
    }

    @Override
    public XObject toXObject(Document context) {
        return new ImageXObject(context, new PdfStream(new PdfDictionary(new PdfName[]{PdfName.Width, PdfName.Height, PdfName.BitsPerComponent, PdfName.ColorSpace, PdfName.Filter}, new PdfDirectObject[]{PdfInteger.get(this.getWidth()), PdfInteger.get(this.getHeight()), PdfInteger.get(this.getBitsPerComponent()), PdfName.DeviceRGB, PdfName.DCTDecode}), new Buffer(this.getStream().toByteArray())));
    }

    private void load() {
        IInputStream stream = this.getStream();
        stream.setByteOrder(ByteOrder.BIG_ENDIAN);
        try {
            int index = 4;
            stream.seek(index);
            byte[] markerBytes = new byte[2];
            do {
                stream.seek(index += stream.readUnsignedShort());
                stream.read(markerBytes);
                index += 2;
            } while (markerBytes[0] != -1 || markerBytes[1] != -64);
            stream.skip(2L);
            this.setBitsPerComponent(stream.readUnsignedByte());
            this.setHeight(stream.readUnsignedShort());
            this.setWidth(stream.readUnsignedShort());
        }
        catch (EOFException e) {
            throw new RuntimeException(e);
        }
    }
}

