/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.composition;

public final class Length {
    private UnitModeEnum unitMode;
    private double value;

    public Length(double value, UnitModeEnum unitMode) {
        this.value = value;
        this.unitMode = unitMode;
    }

    public UnitModeEnum getUnitMode() {
        return this.unitMode;
    }

    public double getValue() {
        return this.value;
    }

    public double getValue(double baseValue) {
        switch (this.unitMode) {
            case Absolute: {
                return this.value;
            }
            case Relative: {
                return baseValue * this.value;
            }
        }
        throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this.unitMode)).getClass().getSimpleName()) + " not supported.");
    }

    public void setUnitMode(UnitModeEnum value) {
        this.unitMode = value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value) + " (" + (Object)((Object)this.unitMode) + ")";
    }

    public static enum UnitModeEnum {
        Absolute,
        Relative;

    }
}

